---
name: discovery
description: Create client discovery questionnaire
---
# Discovery Questionnaire Generator

Generate comprehensive discovery questionnaires tailored to AI agency prospects.

## Usage

When a user requests a discovery questionnaire, create a customized set of questions based on the project type, client industry, and engagement scope.

## Questionnaire Structure

### 1. Business Context (Understanding the Client)
- Company overview and history
- Current business model
- Market position and competitors
- Growth goals and challenges
- Decision-making process

### 2. Current State Assessment
- Existing tools and systems
- Current workflows and processes
- Pain points and bottlenecks
- Manual processes ripe for automation
- Data sources and integrations

### 3. Project Goals & Objectives
- Primary objectives
- Success metrics (KPIs)
- Timeline and urgency
- Budget range
- Expected ROI

### 4. Technical Environment
- Existing tech stack
- API access and documentation
- Data security requirements
- Compliance needs (GDPR, HIPAA, etc.)
- IT/development team involvement

### 5. Team & Stakeholders
- Key stakeholders and roles
- End users of the solution
- Decision makers
- Implementation team
- Training requirements

### 6. Scope & Deliverables
- Must-have features
- Nice-to-have features
- Out of scope
- Integration requirements
- Ongoing support needs

## Questionnaire Templates

### AI Automation Project
```markdown
# Discovery Questionnaire: AI Automation Project

## Client Information
- Company Name:
- Industry:
- Company Size:
- Contact Name & Role:
- Project Sponsor:

## Business Context
1. What is your company's primary business model?
2. What are your top 3 business goals for the next 12 months?
3. What challenges are preventing you from achieving these goals?
4. How do you currently measure success in your operations?

## Current State
5. What processes consume the most time in your organization?
6. Which of these processes are currently manual?
7. What tools/software do you currently use for these processes?
8. What pain points do you experience with current solutions?
9. Have you attempted automation before? What were the results?

## Project Vision
10. What specific process do you want to automate?
11. What would success look like for this project?
12. How many people are involved in this process currently?
13. How much time per week is spent on this process?
14. What is the estimated time/cost savings you expect?

## Technical Requirements
15. What systems need to be integrated? (List all)
16. Do you have API access to these systems?
17. What is your current data infrastructure? (Cloud, on-premise, hybrid)
18. Are there any security or compliance requirements we should know about?
19. Who will manage the solution after implementation?

## Stakeholders & Users
20. Who are the end users of this automation?
21. What is their technical skill level?
22. Who needs to approve this project?
23. What is the typical decision-making timeline?
24. Will we have direct access to end users for feedback?

## Scope & Timeline
25. What is your ideal launch date?
26. Are there any hard deadlines we should be aware of?
27. What features are absolutely required for v1.0?
28. What features can wait for future phases?
29. What is your budget range for this project?

## Post-Launch
30. What level of ongoing support do you expect?
31. Who will handle day-to-day maintenance?
32. How do you envision scaling this solution?
33. What metrics will you use to measure ROI?
```

### AI Content Generation Project
```markdown
# Discovery Questionnaire: AI Content Generation

## Content Strategy
1. What types of content do you currently create?
2. What is your content publishing frequency?
3. Who creates content currently? (Roles/team size)
4. How much time per week is spent on content creation?
5. What is your content approval process?

## Content Requirements
6. What platforms do you publish to?
7. What is your brand voice and tone?
8. Are there any topics or language to avoid?
9. Do you have brand guidelines we should follow?
10. What content formats do you need? (Blog, social, email, etc.)

## Current Challenges
11. What are your biggest content creation bottlenecks?
12. Where do you struggle most in the content pipeline?
13. What tools do you currently use for content?
14. What's working well that we should preserve?
15. Have you used AI for content before? Experience?

## AI Integration
16. How much human review do you want in the process?
17. What level of customization do you need per post?
18. Do you need multi-language support?
19. Should AI be trained on your existing content?
20. What's your comfort level with AI-generated content?

## Success Metrics
21. How will you measure content quality?
22. What engagement metrics matter most?
23. What is your goal for content output volume?
24. What time savings would make this successful?
25. What is your expected ROI timeline?
```

### AI Customer Support Automation
```markdown
# Discovery Questionnaire: AI Customer Support

## Current Support Operations
1. What support channels do you offer? (Email, chat, phone, etc.)
2. What is your average ticket volume per day/week/month?
3. What is your current average response time?
4. What is your current average resolution time?
5. How many support team members do you have?

## Support Challenges
6. What types of inquiries are most common?
7. What percentage of tickets are repetitive/simple?
8. What are your biggest support bottlenecks?
9. When do you experience support volume spikes?
10. What is your current customer satisfaction score?

## Automation Goals
11. What types of inquiries do you want AI to handle?
12. What should always be escalated to humans?
13. Do you want AI to draft responses for human review?
14. Or should AI respond directly for certain categories?
15. What is your risk tolerance for AI mistakes?

## Integration Requirements
16. What is your current support platform? (Zendesk, Intercom, etc.)
17. What is your knowledge base platform?
18. What CRM do you use?
19. Do you have a ticketing API we can access?
20. Where is historical support data stored?

## Quality & Training
21. How will you measure AI response quality?
22. Who will review and improve AI responses?
23. Do you have documentation for AI training?
24. How often will you want to retrain the AI?
25. What is your plan for handling edge cases?

## Success Metrics
26. What response time are you targeting?
27. What resolution rate would make this successful?
28. What CSAT score improvement are you expecting?
29. What cost savings are you targeting?
30. How soon do you expect to see ROI?
```

## Best Practices

### Questions Should Be:
1. **Open-ended** - Encourage detailed responses
2. **Specific** - Avoid vague questions
3. **Prioritized** - Most important questions first
4. **Logical flow** - Group related questions
5. **Actionable** - Answers should inform project decisions

### Avoid:
1. **Leading questions** - Don't bias responses
2. **Technical jargon** - Unless client is technical
3. **Too many questions** - Keep under 35
4. **Yes/no questions** - Get details instead
5. **Assumptions** - Ask, don't assume

### Follow-up Strategy:
1. **Send questionnaire** - With context and deadline
2. **Schedule review call** - Discuss responses
3. **Clarify answers** - Ask follow-ups
4. **Document findings** - Create discovery summary
5. **Propose solution** - Based on discovery

## Output Format

```markdown
# [Project Type] Discovery Questionnaire
**Prepared for:** [Client Name]
**Date:** [Date]
**Prepared by:** [Your Agency]

## Introduction
[Brief paragraph explaining the purpose of this questionnaire and how responses will be used]

## Section 1: [Category Name]
1. Question text here?
2. Question text here?
[...]

## Section 2: [Category Name]
[...]

## Next Steps
After completing this questionnaire:
1. We'll schedule a 30-minute discovery call to review your responses
2. We'll prepare a preliminary solution proposal
3. We'll provide a detailed scope and timeline estimate
4. We'll present our recommendation in a follow-up meeting

## Submission
Please complete this by [DATE] and send to [EMAIL].
Questions? Contact [NAME] at [EMAIL/PHONE].
```

## Customization Tips

**For Small Businesses:**
- Simpler language
- Fewer technical questions
- Focus on ROI and time savings
- Shorter questionnaire (20-25 questions)

**For Enterprises:**
- Include compliance questions
- Ask about procurement process
- Include security requirements
- Add stakeholder mapping
- Longer, more detailed (30-40 questions)

**For Technical Clients:**
- Use technical terminology
- Ask about architecture
- Include API/integration details
- Ask about dev team involvement

**For Non-Technical Clients:**
- Plain language
- Focus on outcomes, not technology
- Include more examples
- Ask about pain points, not technical specs

## Delivery Method

**Email:**
- Google Form or Typeform
- PDF with form fields
- Word/Google Doc

**Video Call:**
- Live interview
- Screen share for note-taking
- Record for reference

**Hybrid:**
- Send questionnaire first
- Review on call
- Ask follow-ups live

This generator helps you create professional discovery questionnaires that uncover the information needed to scope and propose AI projects effectively.
