# Brand Strategy Framework

A systematic 7-part methodology for building brand foundations — the same process top agencies use with Fortune 500 clients.

## Installation

```bash
/plugin install brand-strategy-framework@claude-code-plugins-plus
```

Or via CLI:
```bash
ccpi install brand-strategy-framework
```

## Overview

This plugin provides a comprehensive brand strategy framework that guides users through 7 sequential phases:

1. **Brand Truth** - Define who the brand authentically is
2. **Audience Architecture** - Define who the brand serves (motivations, not demographics)
3. **Cultural Context** - Position the brand within the broader landscape
4. **Messaging Framework** - Translate strategy into language
5. **Visual Language** - Define principles for visual identity
6. **Channel Strategy** - Define where and how the brand shows up
7. **Measurement Framework** - Define what success looks like

## Usage

The skill auto-activates when you mention:
- "create brand strategy"
- "build brand brief"
- "define brand positioning"
- "brand messaging"
- "audience architecture"
- "brand truth"
- "go-to-market brand plan"

### Examples

```
"Help me create a brand strategy for my new coffee subscription service"
→ Begins with Phase 1 (Brand Truth) discovery questions

"I need to define our target audience"
→ Jumps to Phase 2 (Audience Architecture)

"Can you write our brand messaging?"
→ Jumps to Phase 4 (Messaging Framework)

"Review my brand strategy"
→ Evaluates against the 7-part framework
```

## Deliverables

Each phase produces a structured output, culminating in a complete Brand Strategy Document:

1. Executive Summary (1 page)
2. Brand Truth statement
3. Audience personas (2-4)
4. Positioning statement + competitive landscape
5. Messaging framework
6. Visual language principles
7. Channel matrix
8. Measurement dashboard

## Author

Created by **Rowan Brooks** ([@rowanbrooks100](https://github.com/rowanbrooks100))

## License

MIT
