---
name: analytics
description: Track content performance across platforms, identify winning patterns, and...
---
# Analytics Insights Command

Track and analyze content performance across all platforms to optimize your content strategy with data-driven decisions.

## Usage

```bash
/analytics dashboard                         # View all-platform dashboard
/analytics video [video-url]                # Analyze specific video
/analytics compare [video1] [video2]        # Compare performance
/analytics trends                           # Identify winning patterns
/analytics optimize                         # Get optimization recommendations
/analytics report [timeframe]               # Generate performance report
```

## Purpose

Make data-driven decisions by:
- **Cross-platform analytics** - See all metrics in one place
- **Pattern identification** - What content performs best
- **Audience insights** - Who watches and engages
- **Optimization recommendations** - What to do next
- **ROI tracking** - Time invested vs results

## Analytics Dashboard

When user runs `/analytics dashboard`:

```
📊 CONTENT PERFORMANCE DASHBOARD

Period: Last 30 Days
Total Videos Published: 8
Total Content Pieces: 42 (including repurposed content)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🎯 KEY METRICS

Total Views: 487,000 (+23% vs previous month)
Total Watch Time: 42,300 hours (+18%)
Total Engagement: 18,400 actions (+31%)
Subscriber Growth: 2,840 (+19%)
Revenue (if monetized): $1,948 (+15%)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📈 TOP PERFORMING CONTENT

#1: "I Made My API 11x Faster" ⭐⭐⭐⭐⭐
├─ Views: 124,000 (25% of total)
├─ CTR: 9.2% (Target: 4.5%)
├─ Retention: 68% (Target: 60%)
├─ Engagement: 4,200 actions
├─ Subscribers: 820 (29% of growth)
└─ Why it worked: Specific result, tutorial format

#2: "Redis vs Memcached Speed Test" ⭐⭐⭐⭐
├─ Views: 89,000
├─ CTR: 7.8%
├─ Retention: 62%
├─ Engagement: 3,100 actions
└─ Why it worked: Comparison, data-driven

#3: "Why Your API is Slow" ⭐⭐⭐⭐
├─ Views: 76,000
├─ CTR: 6.9%
├─ Retention: 64%
├─ Engagement: 2,600 actions
└─ Why it worked: Problem identification

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 PLATFORM BREAKDOWN

YouTube (Primary):
├─ Videos: 8
├─ Views: 342,000 (70% of total)
├─ Avg CTR: 7.2%
├─ Avg Retention: 63%
└─ Performance: Excellent ✓✓

TikTok (Clips):
├─ Posts: 16 (2 per video)
├─ Views: 89,000 (18% of total)
├─ Avg Engagement: 6.8%
└─ Performance: Great ✓

LinkedIn (Professional):
├─ Posts: 8
├─ Views: 34,000 (7% of total)
├─ Avg Engagement: 4.2%
└─ Performance: Good ✓

Twitter (Threads):
├─ Threads: 8
├─ Impressions: 18,000 (4% of total)
├─ Engagement Rate: 4.1%
└─ Performance: Needs improvement ⚠️

Blog (SEO):
├─ Posts: 8
├─ Pageviews: 4,000 (1% of total, growing)
├─ Avg Time: 4:12
└─ Performance: Building ⏳

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

👥 AUDIENCE INSIGHTS

Demographics:
├─ Age: 25-34 (48%), 18-24 (28%), 35-44 (18%)
├─ Gender: 78% male, 21% female, 1% other
├─ Location: US (42%), India (18%), UK (12%)
└─ Devices: Mobile (62%), Desktop (31%), Tablet (7%)

Interests:
├─ Web Development (92%)
├─ Backend Engineering (78%)
├─ DevOps (65%)
├─ System Design (58%)
└─ Cloud Computing (54%)

Watch Patterns:
├─ Peak time: 7pm-10pm EST (evenings)
├─ Peak days: Tuesday, Wednesday, Saturday
├─ Avg session: 8.2 minutes
└─ Returning viewers: 34%

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🎯 WINNING PATTERNS

Content Type Performance:
1. Transformation Stories (11x faster): 9.2 CTR, 68% retention ⭐⭐⭐⭐⭐
2. Tool Comparisons (X vs Y): 7.8 CTR, 62% retention ⭐⭐⭐⭐
3. Problem/Solution: 6.9 CTR, 64% retention ⭐⭐⭐⭐
4. Tutorials: 5.4 CTR, 58% retention ⭐⭐⭐
5. Tips/Lists: 4.2 CTR, 52% retention ⭐⭐

Title Formula Performance:
1. "I [Action] [Thing] X% [Result]": 9.2% avg CTR ⭐⭐⭐⭐⭐
2. "X vs Y": 7.8% avg CTR ⭐⭐⭐⭐
3. "Why [Problem] (How to Fix)": 6.9% avg CTR ⭐⭐⭐⭐
4. "[Do Thing] in [Time]": 5.4% avg CTR ⭐⭐⭐
5. "[Number] Tips for [Result]": 4.2% avg CTR ⭐⭐

Video Length Performance:
├─ 8-12 minutes: 67% avg retention (optimal) ⭐⭐⭐⭐⭐
├─ 5-8 minutes: 64% avg retention ⭐⭐⭐⭐
├─ 12-15 minutes: 58% avg retention ⭐⭐⭐
└─ 15+ minutes: 48% avg retention ⚠️

Thumbnail Style Performance:
├─ Before/After: 9.2% CTR ⭐⭐⭐⭐⭐
├─ Comparison/VS: 7.8% CTR ⭐⭐⭐⭐
├─ Bold Text + Face: 6.5% CTR ⭐⭐⭐
└─ Minimal: 4.2% CTR ⚠️

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💡 OPTIMIZATION RECOMMENDATIONS

Immediate Actions (This Week):
✓ Double down on transformation stories (your best format)
✓ Create more comparison videos (X vs Y performs well)
✓ Keep videos 8-12 minutes (sweet spot for retention)
✓ Use before/after thumbnails (highest CTR)
✓ Post Tuesday/Wednesday 9am EST (best performance)

Content Strategy (Next Month):
✓ Create series: "API Performance Mastery" (6 videos)
✓ More TikTok clips (strong engagement, low effort)
✓ Improve Twitter strategy (lowest performer)
✓ Start email list (capture blog traffic)
✓ Collaborate with 2-3 creators (expand reach)

Stop Doing:
❌ Long videos (15+ min) - poor retention
❌ Generic titles ("How to...") - low CTR
❌ Minimal thumbnails - underperform by 50%
❌ Weekend uploads - 30% less views
❌ Twitter link posts - native video performs 5x better

Expected Results (If Implemented):
├─ Views: +35% (487K → 657K per month)
├─ Subscribers: +40% (2,840 → 3,976 per month)
├─ Watch time: +28% (42K → 54K hours)
└─ Revenue: +32% ($1,948 → $2,572 per month)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

## Video-Specific Analysis

When user runs `/analytics video [youtube-url]`:

```
📹 VIDEO ANALYSIS

Title: "I Made My API 11x Faster (Redis Tutorial)"
Published: January 15, 2025 (18 days ago)
Length: 10:12

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 PERFORMANCE METRICS

Views: 124,000 (6,888/day avg)
Watch Time: 14,200 hours
Impressions: 1,347,826
CTR: 9.2% (YouTube avg: 4.5%) ✓✓
Avg View Duration: 6:54 (68% retention) ✓
Likes: 8,472 (6.8% engagement) ✓
Comments: 847
Shares: 234
Subscribers Gained: 820
Revenue: $496 ($4 CPM)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📈 GROWTH TRAJECTORY

Day 1: 8,200 views (strong premiere)
Day 2: 12,400 views (+51%)
Day 3: 9,800 views
Week 1: 42,000 views
Week 2: 68,000 views (trending)
Current: 124,000 views

Projection:
├─ 30 days: 180K views
├─ 90 days: 320K views
└─ 365 days: 580K views

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🎯 TRAFFIC SOURCES

YouTube Search: 42,000 views (34%)
├─ "redis tutorial": 12,400
├─ "make api faster": 8,900
├─ "api performance": 6,700
└─ Other keywords: 14,000

Browse Features: 38,000 views (31%)
├─ Home feed: 24,000
└─ Recommended: 14,000

Suggested Videos: 28,000 views (23%)
├─ Your videos: 16,000
└─ Other channels: 12,000

External: 10,000 views (8%)
├─ Blog: 4,200
├─ Twitter: 2,800
├─ LinkedIn: 2,100
└─ Other: 900

Direct/Unknown: 6,000 views (5%)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📍 RETENTION ANALYSIS

Audience Retention:
100% |████▓▓▓▓▓▓░░░░░░░░░▓▓░░░
     |
 75% |
     |
 50% |
     |
 25% |
     +-------------------------------->
     0:00    5:00    10:00

Key Moments:
├─ 0:00-0:15 (Hook): 95% retained ✓✓
├─ 0:15-2:00 (Problem): 88% retained ✓
├─ 2:00-7:00 (Solution): 72% retained ✓
├─ 7:00-9:30 (Implementation): 61% retained ⚠️
└─ 9:30-10:12 (Conclusion): 58% retained

Drop-off Points:
⚠️ 4:30 (10% drop) - Installation section too slow
⚠️ 7:45 (8% drop) - Code walkthrough too detailed
⚠️ 9:00 (7% drop) - Losing energy near end

Improvements for Next Video:
✓ Speed up installation section (1.2x speed)
✓ Use animations for code explanations
✓ Keep high energy throughout
✓ Stronger ending/CTA

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💬 ENGAGEMENT ANALYSIS

Comments: 847 total
├─ Positive: 720 (85%)
├─ Questions: 89 (10%)
├─ Negative: 38 (5%)

Common Themes:
✓ "This helped me so much!" (214 comments)
✓ "Can you do [related topic]?" (89 comments)
✓ "What about [edge case]?" (54 comments)
⚠️ "Too fast for beginners" (32 comments)

Content Ideas from Comments:
1. "Redis vs Memcached" (requested 23 times)
2. "Redis for session storage" (requested 18 times)
3. "Redis cluster setup" (requested 14 times)
4. "Caching strategies" (requested 12 times)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🏆 PERFORMANCE RATING

Overall: 9.2/10 (Exceptional) ⭐⭐⭐⭐⭐

CTR: 10/10 (9.2% - Elite tier)
Retention: 9/10 (68% - Excellent)
Engagement: 9/10 (6.8% - Above average)
Growth: 9/10 (Trending, sustained views)
Revenue: 8/10 ($4 CPM - Good for tech)

This is your best-performing video. Analyze and replicate this format.

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

## Comparison Analysis

When user runs `/analytics compare [video1] [video2]`:

```
🆚 VIDEO COMPARISON

Video A: "I Made My API 11x Faster"
Video B: "Add Redis Caching in 15 Minutes"

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Views:
A: 124,000 | ████████████████████ | 100%
B:  42,000 | ██████▌              |  34%
Winner: Video A (+195%)

CTR:
A: 9.2% | ████████████████████ | 100%
B: 5.4% | ███████████▌         |  59%
Winner: Video A (+70%)

Retention:
A: 68% | ████████████████████ | 100%
B: 58% | ████████████████▌    |  85%
Winner: Video A (+17%)

Engagement:
A: 6.8% | ████████████████████ | 100%
B: 4.2% | ████████████▌        |  62%
Winner: Video A (+62%)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

WHY VIDEO A OUTPERFORMED:

Title:
A: "I Made My API 11x Faster" (result-focused) ✓
B: "Add Redis Caching in 15 Minutes" (process-focused)

Thumbnail:
A: Before/after with metrics (high contrast) ✓
B: Code screenshot (less engaging)

Hook:
A: "11x faster in 1 hour" (specific, surprising) ✓
B: "Here's how to add caching" (expected)

Format:
A: Transformation story (personal journey) ✓
B: Tutorial (instructional)

Key Lesson:
Result-focused content with specific metrics outperforms process-focused tutorials by 195% in views and 70% in CTR.

Recommendation:
Transform tutorial content into transformation stories when possible.

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

## Integration Points

Works with other Creator Studio plugins:

- **viral-idea-generator**: Validate ideas with past performance data
- **title-optimizer**: A/B test titles with real data
- **distribution-automator**: Optimize distribution timing
- **content-calendar-ai**: Schedule based on best-performing days
- **video-editor-ai**: Identify retention drop-off points for editing

## Best Practices

### Metrics to Track
1. **CTR** - Are people clicking? (Target: 6%+)
2. **Retention** - Are they watching? (Target: 60%+)
3. **Engagement** - Are they interacting? (Target: 5%+)
4. **Growth** - Are you gaining subscribers? (Target: 0.5%+ conversion)
5. **Revenue** - Is it financially sustainable? (Track CPM, sponsorships)

### Analysis Frequency
- **Daily**: Check first 24 hours performance
- **Weekly**: Review all content from past week
- **Monthly**: Deep dive into trends and patterns
- **Quarterly**: Major strategy review and pivots

Your goal: Turn data into actionable insights that improve content performance and grow your audience.
