# Social Media Distribution Checklist

**Complete checklist for distributing video content across social platforms**

---

## Twitter/X Distribution

### Thread Creation

- [ ] **Hook tweet** written (first tweet is critical)
- [ ] **Video link** included (preferably in first tweet)
- [ ] **Thread length**: 5-7 tweets ideal
- [ ] **30-second clip** attached to first tweet
- [ ] **Key takeaways** one per tweet (tweets 2-5)
- [ ] **Code snippets** formatted with syntax highlighting
- [ ] **Screenshots** of key moments added
- [ ] **GIFs/memes** for personality (if brand-appropriate)
- [ ] **Final tweet**: Strong CTA + video link again
- [ ] **Hashtags**: 2-3 relevant tags (not overused)
- [ ] **Mentions**: Tag relevant people/tools/technologies

### Thread Structure Example
```
Tweet 1: Hook + problem + 30s clip + video link
Tweet 2: Key takeaway #1 + screenshot
Tweet 3: Key takeaway #2 + code snippet
Tweet 4: Key takeaway #3 + screenshot
Tweet 5: Surprising insight + GIF
Tweet 6: Call to action + video link
```

### Engagement

- [ ] **Posted at optimal time** (check your analytics)
- [ ] **Pinned to profile** (first 24 hours)
- [ ] **Reply to comments** within first hour
- [ ] **Retweet with comment** after 4-6 hours
- [ ] **Quote tweet** with additional insight next day
- [ ] **Add to Twitter Moment** (if series)

### Short-Form Clips

- [ ] **3-5 clips created** from main video (30-60 seconds each)
- [ ] **Native Twitter video** (better algorithm boost than YouTube links)
- [ ] **Vertical format** (9:16) for mobile
- [ ] **Captions burned in** (most watch without sound)
- [ ] **Posted throughout week** (not all at once)

---

## LinkedIn Distribution

### Article Post

- [ ] **Article created** (500-1000 words)
- [ ] **Professional headline** (65 characters max)
- [ ] **Video embedded** (first 2 minutes OR full video)
- [ ] **Executive summary** (3-4 sentences)
- [ ] **Key learnings** numbered list
- [ ] **Code examples** if applicable (less code than dev-focused platforms)
- [ ] **Business value** emphasized (ROI, efficiency, scalability)
- [ ] **Call to action**: Watch full video, comment, share
- [ ] **Hashtags**: 3-5 professional tags
- [ ] **Published as article** (not just link post)

### Article Structure
```
Headline: [Professional, benefit-focused]

Opening: [Hook + context]

Body:
- Challenge you faced
- Approach you took
- Key learnings (3-5 points)
- Business impact

Embedded video: [2 minutes or full]

Conclusion: [Takeaway + CTA]

Hashtags: #WebDevelopment #CloudComputing #DevOps
```

### LinkedIn Video Post (Alternative)

- [ ] **Native upload** (better reach than YouTube link)
- [ ] **Square format** (1:1) or landscape (16:9)
- [ ] **Captions** burned in or uploaded
- [ ] **Professional thumbnail** (auto-selected or custom)
- [ ] **Caption**: 150-300 characters (LinkedIn shows first 140)
- [ ] **Hashtags**: 3-5 tags
- [ ] **Tag relevant people/companies** (if applicable)

### Engagement

- [ ] **Posted at optimal time** (Tue-Thu, 10am-12pm EST best for B2B)
- [ ] **Responded to comments** within 2 hours
- [ ] **Engaged with shares** (comment on reposts)
- [ ] **Posted to relevant LinkedIn groups** (with context)
- [ ] **Added to Featured section** on profile (if top content)

---

## Instagram Distribution

### Feed Post

- [ ] **Thumbnail image** or short clip (under 60 seconds)
- [ ] **Caption** written (2200 character limit)
- [ ] **First line hooks** (before "...more")
- [ ] **Line breaks** for readability
- [ ] **Hashtags**: 8-15 relevant tags
- [ ] **Location tag** if applicable
- [ ] **Alt text** added (accessibility + SEO)
- [ ] **Tagged accounts** (tools, collaborators)

### Instagram Reels

- [ ] **Vertical video** created (9:16 format)
- [ ] **15-90 seconds** (shorter performs better)
- [ ] **Hook in first 3 seconds**
- [ ] **Captions burned in** (most watch muted)
- [ ] **Trending audio** (if applicable)
- [ ] **Text overlays** for key points
- [ ] **Cover image** selected (attractive, clear)
- [ ] **Caption** with value + CTA
- [ ] **Hashtags**: 8-12 tags
- [ ] **Posted at optimal time** (7-9pm best)

### Instagram Stories

- [ ] **5-7 story slides** created
- [ ] **Slide 1**: Hook + what you'll learn
- [ ] **Slides 2-5**: Key points (one per slide)
- [ ] **Slide 6**: CTA (swipe up link if >10K followers)
- [ ] **Slide 7**: "Link in bio" direction
- [ ] **Stickers**: Polls, questions, quiz for engagement
- [ ] **Hashtags**: 1-3 tags (use stickers)
- [ ] **Location tag** (use sticker)
- [ ] **Link sticker** (if available)

### IGTV / Long-Form Video

- [ ] **Full video uploaded** (up to 60 minutes)
- [ ] **Vertical or landscape** (both work)
- [ ] **Cover image** designed
- [ ] **Title** optimized (under 75 characters)
- [ ] **Description** with keywords and links
- [ ] **Series** selected (if part of series)
- [ ] **Posted to feed** as well (visibility boost)

---

## TikTok Distribution

### Video Creation

- [ ] **Vertical video** (9:16 format)
- [ ] **15-60 seconds** (shorter often performs better)
- [ ] **Hook in first 1 second** (critical on TikTok)
- [ ] **Captions** auto-generated and reviewed
- [ ] **Text overlays** for emphasis
- [ ] **Trending sounds** considered (but not forced)
- [ ] **Effects** used if appropriate (but not overused)

### Posting

- [ ] **Caption** written (150 characters, be creative)
- [ ] **Hashtags**: 3-5 relevant tags (#LearnOnTikTok, #CodeTok, #TechTok)
- [ ] **Duet/Stitch** enabled (encourage engagement)
- [ ] **Comments** allowed
- [ ] **Cover** selected (first frame or custom)
- [ ] **Posted at optimal time** (check TikTok Pro analytics)

### Content Types That Work

- Quick tips (30 seconds)
- "Watch me build X in 60 seconds" (time-lapse)
- Debugging fails → wins
- Before/after results
- "You're doing X wrong" (controversy)
- "Here's how X actually works"

---

## Reddit Distribution

### Subreddit Research

- [ ] **Relevant subreddits** identified
  - r/programming
  - r/webdev
  - r/learnprogramming
  - r/javascript (or specific tech)
  - r/SideProject (for builds)
  - r/startups (for business content)
- [ ] **Rules read** for each subreddit
- [ ] **Self-promotion policy** checked
- [ ] **Best time to post** identified (subreddit-specific)

### Post Creation

- [ ] **Title** clear and descriptive (not clickbaity)
- [ ] **Context provided** (2-3 paragraphs)
- [ ] **Why it's relevant** explained
- [ ] **What viewers will learn** listed
- [ ] **Code snippets** included (if tutorial)
- [ ] **GitHub link** provided (if applicable)
- [ ] **Video linked** (not just thumbnail)
- [ ] **Flair** selected (if required)

### Post Format Example
```
Title: [Clear, descriptive, honest]

I built [X] and here's what I learned about [Y]

[2-3 paragraph context]

In this video, I cover:
- [Point 1]
- [Point 2]
- [Point 3]

GitHub: [link]
Video: [link]

Happy to answer questions!
```

### Engagement

- [ ] **Monitor comments** closely (first 2 hours critical)
- [ ] **Respond to ALL comments** (shows good faith)
- [ ] **Provide value** in responses (not just "thanks")
- [ ] **Don't be defensive** (Reddit values humility)
- [ ] **Answer technical questions** thoroughly
- [ ] **Upvote good questions** (build community)

### Reddit Rules

- [ ] **10:1 ratio** followed (1 self-promo per 10 contributions)
- [ ] **Not spamming** multiple subreddits at once (space out posts)
- [ ] **Genuine engagement** in communities (not just posting links)
- [ ] **Following subreddit rules** (some ban self-promotion)

---

## Discord Communities

### Server Selection

- [ ] **Relevant servers** identified
  - Programming Discord servers
  - Framework-specific communities
  - Creator communities
  - Tech education servers
- [ ] **Rules read** carefully
- [ ] **Self-promotion channels** located
- [ ] **Contribution established** before promoting

### Post Creation

- [ ] **Context given**: "Hey everyone, I made a video on X because..."
- [ ] **Value stated**: "You might find this useful if you're working on Y"
- [ ] **Discussion starter**: "What's your experience with Z?"
- [ ] **Not spamming**: Post in appropriate channel only
- [ ] **Engagement ready**: Prepared to answer questions

### Best Practices

- Be a community member first, promoter second
- Contribute to discussions regularly
- Help others with their questions
- Only share when genuinely relevant
- Respond to feedback (positive and negative)

---

## Facebook Groups

### Group Selection

- [ ] **Relevant groups** found
  - Web development groups
  - Tech education groups
  - Startup/entrepreneur groups
  - Local tech communities
- [ ] **Rules reviewed** (many have strict self-promotion rules)
- [ ] **Active participation** established before posting

### Post Creation

- [ ] **Context paragraph** (explain why you're sharing)
- [ ] **Value proposition**: "This will help if you're struggling with X"
- [ ] **Discussion question**: "How do you handle Y?"
- [ ] **Native video** preferred over YouTube link (Facebook algorithm)
- [ ] **Subtitles** included (Facebook auto-play is muted)

---

## Hacker News

### When to Post

- Projects with technical depth
- Unique technical insights
- Open source releases
- Interesting problem-solving stories

### Posting Guidelines

- [ ] **Title** clear and factual (no clickbait)
- [ ] **Timing**: Tuesday-Thursday, 8-11am EST
- [ ] **Original content** (not repost)
- [ ] **Technically interesting** (HN audience is technical)
- [ ] **GitHub link** in first comment (if applicable)
- [ ] **Respond to comments** quickly
- [ ] **Technical discussion** (not promotional)

### What Works on HN

- "Show HN: [project name]" (for projects)
- Technical deep dives
- Problem-solving stories
- Performance optimizations
- Architectural decisions

---

## Dev.to / Hashnode / Medium

### Article Creation

- [ ] **Full tutorial** written (not just video link)
- [ ] **Code snippets** formatted properly
- [ ] **Images/screenshots** included
- [ ] **Video embedded** (in addition to text)
- [ ] **SEO optimized**: Title, meta description, tags
- [ ] **Canonical URL** set (if cross-posting)
- [ ] **Call to action**: Watch video, subscribe, comment
- [ ] **Tags** selected (4-5 relevant tags)

### Article Structure

```
# Title

[Hook paragraph]

[Video embed]

## Introduction
[What you'll learn]

## Step 1: [Topic]
[Explanation + code + screenshot]

## Step 2: [Topic]
[Explanation + code + screenshot]

[... more steps ...]

## Conclusion
[Summary + CTA]

## Resources
- GitHub: [link]
- Video: [link]
- Related articles: [links]
```

---

## Cross-Platform Strategy

### Day 1: Launch Day

- **Hour 1**: YouTube + Twitter thread + LinkedIn article
- **Hour 2**: Instagram Reel + Story + TikTok
- **Hour 4**: Reddit (1-2 subreddits with context)
- **Hour 6**: Discord/Slack communities
- **Hour 12**: Blog post published

### Day 2-3: Short Clips

- Post individual clips on Twitter
- TikTok follow-ups (different angles)
- Instagram Reels (repurposed clips)
- LinkedIn video posts

### Day 4-7: Community Engagement

- Respond to all comments
- Post follow-up content based on questions
- Share user success stories
- Create quote graphics from best comments

---

## Analytics to Track

### Platform-Specific Metrics

**Twitter**:
- Impressions, engagements, clicks
- Best performing tweets
- Profile visits from thread

**LinkedIn**:
- Views, reactions, comments, shares
- Profile views from article
- Connection requests

**Instagram**:
- Reach, saves, shares
- Profile visits
- Website clicks (if link available)

**TikTok**:
- Views, likes, shares, comments
- Watch time percentage
- Profile visits

**Reddit**:
- Upvotes, comments
- Traffic to video
- Quality of discussion

---

## Tools for Social Media Distribution

**Scheduling**:
- Buffer (multi-platform)
- Hootsuite (enterprise)
- Later (Instagram focus)
- TweetDeck (Twitter)

**Analytics**:
- Native platform analytics
- Google Analytics (website traffic)
- Bitly (link tracking)

**Content Creation**:
- Canva (graphics)
- Kapwing (video editing)
- GIPHY (GIFs)
- Carbon (code screenshots)

---

**Social media distribution = Multiple touchpoints, consistent value, authentic engagement.** 🚀

---

**Version**: 1.0.0
**Checklist Type**: Social Media Distribution
