# Build Log Video Script Template

**Use this template for**: Documenting your building journey, progress updates, and "building in public" content.

---

## Video Information

**Title**: [Day/Week X: What I Built OR Milestone Description]

**Project**: [What are you building?]

**Duration Target**: [5-10 minutes for daily, 8-15 for weekly]

**Key Achievement**: [What progress did you make?]

**Format**: [Time-lapse, talking head, screen recording, or hybrid]

---

## Script Structure

### COLD OPEN (0:00-0:10) - 10 seconds

**Visual**: [Show your best moment/achievement first - the payoff]

**Script**:
```
[No talking - just show the working result]

[OR quick teaser:]
"I just got [X] working after [Y hours/days] of building."

[Show the moment of success]
```

**On-Screen Text**:
- Achievement headline
- Project name
- Day/Week number

**Example**:
```
[Screen shows: User logging in successfully, animated celebration]

[Your voice, excited:]
"YES! Authentication is finally working!"

[On-screen: "Day 3: User Auth Complete ✅"]
```

---

### HOOK (0:10-0:30) - 20 seconds

**Visual**: [Your face OR workspace]

**Script**:
```
"What's up everyone, [name] here.

[Context: Where you are in the journey]
'It's [Day/Week X] of building [project name].'

[Quick status update]
'Today/This week I [accomplished X].'

[Build curiosity]
'But getting here was not easy...'

[OR alternative:]
'Let me show you exactly what I built and the challenges I faced.'

Let's jump into it."
```

**On-Screen Text**:
- Day/Week number
- Project name
- Current status

**Example**:
```
"What's up everyone, Jeremy here.

It's Day 3 of building my SaaS project, and today I finally got user authentication working.

But this took way longer than expected because I ran into 3 major issues.

Let me show you what I built and what I learned."
```

---

### CONTEXT (0:30-1:30) - 60 seconds

**Visual**: [Screen recording OR talking head with B-roll]

**Script**:
```
"Quick context for anyone new:

[Project overview]
'I'm building [project name] - it's a [description].'

[Why you're building it]
'The reason I'm building this is [motivation/problem you're solving].'

[Where you are in the journey]
'I started [X days/weeks] ago, and here's where I am:

Progress so far:
✅ [Completed item 1]
✅ [Completed item 2]
🚧 [Current work]
⏭️ [Next up]'

[Today/This week's goal]
'Today/This week, my goal was to [specific goal].'

[Transition]
'So let me show you what I built...'"
```

**On-Screen Text**:
- Project summary (1-2 sentences)
- Progress checklist
- Today's goal highlighted

**Editing Note**: Show screenshots or screen recordings of completed features while you talk.

---

### BUILD SEGMENT 1: Starting Point (1:30-3:00) - 90 seconds

**Visual**: [Screen recording - code/app state at start]

**Script**:
```
"Here's where I started [today/this week]:

[Show starting state]
'As you can see, [description of starting point].'

[What needed to be done]
'What I needed to build was [requirement].'

[Initial approach]
'My plan was to:
1. [Step 1]
2. [Step 2]
3. [Step 3]'

[Optional: Why this approach]
'I chose this approach because [reasoning].'

[Time-lapse intro if using]
'Let me speed through the first part...'

[Show time-lapse of initial work OR key screenshots]

[Narration over time-lapse:]
'First, I set up [X]...
Then I added [Y]...
Started to see progress...'

[Stop at first major milestone/problem]

And that's when I hit my first issue..."
```

**On-Screen Text**:
- Starting state screenshot
- Plan overview
- Time-lapse speed indicator ("10x speed")
- Timestamp markers

---

### CHALLENGE 1 (3:00-4:30) - 90 seconds

**Visual**: [Screen recording - debugging/problem-solving]

**Script**:
```
"So here's what went wrong:

[Show the problem]
'[X] wasn't working because [reason].'

[Show your reaction/thought process]
'At first I thought it was [wrong theory].'

[Show what you tried]
'I tried:
- [Attempt 1] - didn't work
- [Attempt 2] - still broken
- [Attempt 3] - getting closer'

[Show the breakthrough]
'Then I realized the actual problem was [root cause].'

[Show the fix]
'Here's how I fixed it...'

[Show result]
'And boom, it's working!'

[Learning moment]
'The lesson here: [what you learned].'

[Transition]
'Okay, one problem down. But then...'"
```

**On-Screen Text**:
- "CHALLENGE #1" header
- Problem description
- Failed attempts (strikethrough)
- Solution (highlighted)
- Lesson learned

**Editing Note**: Keep the struggle real. Show failed attempts briefly. Celebrate the win.

---

### BUILD SEGMENT 2: Main Implementation (4:30-6:30) - 2 minutes

**Visual**: [Time-lapse OR screen recording with voiceover]

**Script**:
```
"With that fixed, I moved on to the main feature:

[What you're building]
'The core functionality is [description].'

[Time-lapse with narration OR step-by-step]

[If time-lapse:]
'Let me speed through the implementation...

[Narrate over time-lapse:]
First, the data structure...
Then the logic...
Adding error handling...
Testing as I go...
Refactoring...
Almost there...'

[If step-by-step:]
'Here's how I built this:

Step 1: [Show implementation]
Step 2: [Show implementation]
Step 3: [Show implementation]'

[Key decision callout]
'I made an important decision here - instead of [option A], I went with [option B] because [reason].'

[Show progress]
'After [X hours], I had the basic version working.'

[But...]
'But there was one more thing...'"
```

**On-Screen Text**:
- Time-lapse speed
- Git commits scrolling
- Progress percentage
- Key decisions highlighted

---

### CHALLENGE 2 (6:30-7:30) - 60 seconds

**Visual**: [Screen recording - second problem]

**Script**:
```
"The second challenge was [problem]:

[Show the issue]
'[What went wrong].'

[Why it was tricky]
'This was harder because [complication].'

[Solution - faster pacing than first challenge]
'I solved it by [solution].'

[Or if still unsolved:]
'I'm still working on the perfect solution, but for now I [workaround].'

[Results]
'And with that, [the feature] was complete.'

[Transition]
'Let me show you the final result...'"
```

**On-Screen Text**:
- "CHALLENGE #2" header
- Problem → Solution flow
- Code snippet of fix

**Editing Note**: Second challenge should be shorter than first - keep momentum.

---

### DEMO/RESULTS (7:30-9:00) - 90 seconds

**Visual**: [Full demo of completed work]

**Script**:
```
"Alright, here's what I built:

[Demo the feature start to finish]
'Let me walk you through this...'

[Show each part working:]
'First, [action 1]...
Then [action 2]...
And finally [action 3]...'

[Highlight the achievement]
'And there you have it - [feature name] fully working!'

[Metrics/stats if applicable]
'Some quick stats:
- [Metric 1]
- [Metric 2]
- [Metric 3]'

[Before/after comparison if applicable]
'Compare this to where I started [show before state].'

[Express genuine excitement]
'I'm really happy with how this turned out.'

[What's unlocked]
'Now that this is working, I can move on to [next feature].'"
```

**On-Screen Text**:
- Feature highlights
- Metrics/stats
- Before/after comparison
- "✅ Completed" badge

---

### LEARNINGS (9:00-10:00) - 60 seconds

**Visual**: [Your face OR split screen with notes]

**Script**:
```
"Quick reflection on what I learned [today/this week]:

[Technical learnings]
Technical takeaways:
1. [Learning 1] - [why it matters]
2. [Learning 2] - [why it matters]
3. [Learning 3] - [why it matters]

[Process learnings]
Process insights:
- [Insight 1]
- [Insight 2]

[What you'd do differently]
If I did this again, I would [improvement].

[Mindset/motivation]
[Personal reflection on the journey]
'[Honest thought about how you're feeling]'

[Transition to next steps]
'Looking ahead...'"
```

**On-Screen Text**:
- Key learnings list
- Technical notes
- Process improvements

---

### NEXT STEPS (10:00-10:45) - 45 seconds

**Visual**: [Screen showing roadmap OR talking head]

**Script**:
```
"So what's next?

[Tomorrow/Next week goals]
[Tomorrow/Next week], I'm going to:
1. [Task 1]
2. [Task 2]
3. [Task 3]

[Bigger picture]
'The goal is to get to [milestone] by [timeframe].'

[Challenges ahead]
'The next big challenge will be [upcoming challenge].'

[Call for engagement]
'If you've tackled [similar problem], let me know your approach in the comments.'

[Building in public message]
'I'm building this in public, so hit subscribe to follow the journey.'

[Outro]
'That's it for [today/this week]. Thanks for watching, and I'll see you in the next one!'"
```

**On-Screen Text**:
- Next goals list
- Timeline/roadmap
- Subscribe reminder

---

### END SCREEN (10:45-11:00) - 15 seconds

**Visual**: [End screen with elements]

**Script**:
```
[No speaking - end screen music]
```

**On-Screen Elements**:
- Next build log (clickable)
- Subscribe button
- Playlist: "Building [Project] Series"
- Social links

---

## Format Variations

### Daily Build Log (5-8 minutes)
**Focus**: What you did today, quick and focused
**Pacing**: Fast, energetic
**Structure**:
- Hook (15s)
- Today's goal (30s)
- Build montage (3m)
- Result (1m)
- Tomorrow's goal (30s)

### Weekly Build Log (10-15 minutes)
**Focus**: Week's progress, multiple features
**Pacing**: Moderate, comprehensive
**Structure**:
- Hook (30s)
- Week recap (1m)
- Feature 1 (3m)
- Feature 2 (3m)
- Feature 3 (3m)
- Results (2m)
- Next week (1m)

### Milestone Build Log (15-20 minutes)
**Focus**: Major achievement, reflection
**Pacing**: Storytelling, emotional
**Structure**:
- Hook (1m)
- Journey so far (2m)
- The challenge (5m)
- The solution (5m)
- The result (3m)
- Reflection (2m)
- What's next (1m)

---

## Time-Lapse Tips

**When to use time-lapse**:
- Long coding sessions
- Repetitive work
- Setup/configuration
- Design iterations

**How to narrate**:
```
"Setting up the database..."
"Writing the API endpoints..."
"Adding error handling..."
"Testing everything..."
"Refactoring for clarity..."
"Almost there..."
```

**Speed recommendations**:
- Code writing: 10-20x speed
- Problem-solving: 5-10x speed
- Important moments: 1x (normal speed)
- Waiting/loading: 50-100x speed

---

## Authenticity Tips

### Show Reality
- Include failures and bugs (briefly)
- Show your actual debugging process
- Express genuine emotions (frustration, excitement)
- Don't hide mistakes

### Be Honest
```
"This took way longer than I expected..."
"I'm not 100% happy with this solution, but..."
"I learned this the hard way..."
"This is probably not the best way to do this..."
```

### Share Struggles
```
"I was stuck on this for 3 hours..."
"I almost gave up on this approach..."
"This bug was driving me crazy..."
"I finally figured it out at 2am..."
```

### Celebrate Wins
```
"YES! Finally!"
"This is working better than I expected!"
"I can't believe that worked!"
"This feels so good!"
```

---

## B-Roll Suggestions

**Throughout the video, include:**
- Time-lapse of coding
- Git commit history scrolling
- Tests passing/failing
- Browser developer tools
- Your workspace/setup
- Coffee/water (building montage)
- Late night coding (if applicable)
- Celebration moments
- Frustrated moments (keep it real)

---

## Description Template

```markdown
[Day/Week X] of building [project name] in public!

Today/This week I [main achievement].

🎯 WHAT I BUILT
- [Feature/Component 1]
- [Feature/Component 2]
- [Feature/Component 3]

💡 WHAT I LEARNED
1. [Learning 1]
2. [Learning 2]
3. [Learning 3]

⚠️ CHALLENGES
- [Challenge 1 + how I solved it]
- [Challenge 2 + how I solved it]

📊 STATS
- Lines of code: [X]
- Commits: [X]
- Time invested: [X] hours
- Coffee consumed: [X] cups ☕

⏱️ TIMESTAMPS
0:00 - Hook
0:30 - Context
1:30 - Starting Point
3:00 - Challenge #1
4:30 - Main Build
6:30 - Challenge #2
7:30 - Demo & Results
9:00 - Key Learnings
10:00 - What's Next

🔗 RESOURCES
GitHub Repo: [link]
Live Demo: [link]
Previous Episode: [link]
Playlist: [link]

🎯 NEXT EPISODE
[Tomorrow/Next week]: [What you'll build next]

💬 BUILDING IN PUBLIC
Follow my journey:
- Twitter: [handle] (daily updates)
- Discord: [link]
- Newsletter: [link]

---

#buildinpublic #[tech] #indiehacker #coding #saas
```

---

## Metrics for Success

**Good build log indicators**:
- Consistent audience returning (subscriber views)
- Comments asking "what's next?"
- "Following your journey!" comments
- Questions about your decisions
- People sharing their own builds
- Steady subscriber growth

**Ideas for improvement**:
- More personal/authentic moments
- Better pacing (too slow/too fast?)
- Show more of the process
- More learnings/insights
- Better celebration of wins

---

## Building in Public Tips

### Consistency
- Same day/time each week
- Same format/structure
- Playlist for easy binge-watching
- Clear episode numbering

### Community
- Reply to every comment
- Ask questions to viewers
- Feature viewer suggestions
- Give shoutouts
- Build in public, learn in public

### Transparency
- Share metrics (when comfortable)
- Discuss business decisions
- Show failures, not just wins
- Talk about what's hard
- Be vulnerable

---

## Common Mistakes to Avoid

1. **Too much detail** - Keep it high-level, link to tutorials for deep dives
2. **Boring pacing** - Use time-lapse and cuts, don't show everything
3. **No emotion** - Let your personality show, celebrate and struggle
4. **Skipping context** - New viewers need to understand the project
5. **Only showing wins** - Authenticity comes from showing the full journey
6. **Inconsistent posting** - Momentum matters for building in public
7. **Ignoring community** - Respond to comments, build relationships

---

## Week-to-Week Continuity

### Episode Opening
```
"Previously, I [last episode summary]...
Today, I'm continuing with [current goal]..."
```

### Episode Closing
```
"Next time, I'll be working on [next goal]...
Don't miss it - hit subscribe!"
```

### Progress Tracking
Show consistent metrics:
- Days/weeks into project
- Features completed vs remaining
- Users (if launched)
- Revenue (if comfortable sharing)

---

**Use this template to document your journey. People love following along.** 🚀

---

**Version**: 1.0.0
**Template Type**: Build Log Video Script
