# Problem-Solution Video Script Template

**Use this template for**: Debugging videos, optimization stories, and "how I fixed X" content.

---

## Video Information

**Problem**: [What was broken/slow/wrong?]
**Solution**: [How you fixed it]
**Duration Target**: [8-12 minutes]
**Key Learning**: [Main takeaway for viewers]
**Format**: [Real-time debugging OR edited story]

---

## Script Structure

### COLD OPEN (0:00-0:15) - 15 seconds

**Visual**: [Show the problem dramatically OR show the final success]

**Script Option A (Show Problem)**:
```
[Screen shows: Error message, slow performance, broken feature]

"My [app/API/feature] is completely broken.

[Show severity]
Look at this - [demonstrate problem]."
```

**Script Option B (Show Success First)**:
```
[Screen shows: Everything working perfectly]

"This is working now. But 3 hours ago, it looked like this...

[Cut to: The broken state]"
```

---

### HOOK (0:15-0:45) - 30 seconds

**Visual**: [Your face showing genuine concern/frustration]

**Script**:
```
"Hey everyone, [name] here.

[The situation]
I've been dealing with [problem] for [timeframe], and it's been driving me crazy.

[Why it matters]
This is blocking [important thing] and costing [time/money/users].

[What you'll see]
In this video, I'm going to show you:
- What went wrong
- How I debugged it
- The solution (and why it works)

[Authenticity]
Fair warning: This gets messy. But that's real debugging.

Let's figure this out together."
```

---

### PROBLEM DEMONSTRATION (0:45-2:00) - 75 seconds

**Visual**: [Screen recording - clearly showing the problem]

**Script**:
```
"First, let me show you exactly what's happening:

[Demo the problem]
'When I [action], instead of [expected result], I get [actual result].'

[Show multiple examples if applicable]
'It's not just once - it happens every time.'

[Show impact]
'This means [consequences]:
- [Impact 1]
- [Impact 2]
- [Impact 3]'

[Context]
'Here's what makes this particularly tricky:
- [Complicating factor 1]
- [Complicating factor 2]'

[Initial theories]
'At first, I thought it might be [theory 1] or [theory 2].'

[Transition]
'Let's start investigating...'"
```

**On-Screen Text**:
- "THE PROBLEM" header
- Error messages (highlighted)
- Impact metrics
- Initial theories list

---

### INVESTIGATION PART 1 (2:00-4:00) - 2 minutes

**Visual**: [Screen recording - debugging process]

**Script**:
```
"My first step: [investigation approach]

[Show debugging process]
'I'm going to check [X]...'

[Narrate your thought process]
'Okay, so [observation]...'
'That's interesting because [reasoning]...'
'Wait, this doesn't make sense...'

[First theory tested]
'My first theory was [theory]. Let me test it...'

[Show test]
[Test result]

[Result]
'Nope, that's not it. [Why theory was wrong].'

[Adjustment]
'Okay, so if it's not [theory 1], maybe it's [theory 2].'

[Second investigation]
'Let me check [Y]...'

[Finding something]
'Wait, look at this...'
[Point out anomaly]

[Partial insight]
'Interesting. This tells me [clue].'

[But still stuck]
'But I still don't know why [root problem].'"
```

**On-Screen Text**:
- "INVESTIGATION" header
- Theories (with strikethroughs when disproven)
- Debug output (highlighted)
- Clues discovered

**Editing Note**: Keep failed attempts brief but present. Show the real process.

---

### BREAKTHROUGH (4:00-5:00) - 60 seconds

**Visual**: [Screen recording - the "aha!" moment]

**Script**:
```
"And then I found it:

[The discovery]
'Look at this - [show the root cause].'

[Aha moment - authentic reaction]
'Oh! That's it! I can't believe I didn't see this before!'

[Explain the root cause]
'The problem is [clear explanation]:
- [Cause detail 1]
- [Cause detail 2]'

[Why it was hard to find]
'This was hard to catch because [reason].'

[How it happened]
'It looks like this started when [origin of bug].'

[Scope]
'And this explains why [all the symptoms].'

[Common mistake callout]
'If you've ever [related situation], this is probably why.'

[Transition]
'Now let's fix it...'"
```

**On-Screen Text**:
- "BREAKTHROUGH 💡" header
- Root cause highlighted
- Architecture diagram (if helpful)
- "This is the culprit" annotation

---

### THE FIX (5:00-7:00) - 2 minutes

**Visual**: [Screen recording - implementing solution]

**Script**:
```
"Here's how to fix it:

[Solution overview]
'The solution is to [approach].'

[Why this approach]
'I chose this approach because [reasoning].'

[Implementation]
'First, [step 1]...'
[Show code/config change]

'Then, [step 2]...'
[Show code/config change]

'And finally, [step 3]...'
[Show code/config change]

[Key implementation detail]
'This line here is important because [explanation].'

[Alternative approaches]
'You could also [alternative], but [why this is better].'

[Edge cases]
'I'm also handling [edge case] by [solution].'

[Testing preparation]
'Moment of truth - let's test this...'"
```

**On-Screen Text**:
- "THE FIX" header
- Code annotations
- Step numbers
- Before/after code comparison

---

### VERIFICATION (7:00-8:30) - 90 seconds

**Visual**: [Screen recording - testing the fix]

**Script**:
```
"Let's see if this works:

[Test 1]
'First test: [action]...'
[Show result]
'Yes! [Success indicator].'

[Test 2]
'Let's try [different scenario]...'
[Show result]
'Perfect!'

[Test 3]
'And the edge case: [edge case test]...'
[Show result]
'All working!'

[Performance metrics if applicable]
'Look at the difference:
Before: [metric]
After: [metric]
Improvement: [percentage]'

[Genuine relief/excitement]
'I am SO relieved this is working!'

[Extra validation]
'Let me run the full test suite...'
[Fast-forward through tests]
'All green! We're good.'"
```

**On-Screen Text**:
- "TESTING" header
- Test results (✅)
- Performance comparison
- "SUCCESS" celebration

---

### EXPLANATION (8:30-10:00) - 90 seconds

**Visual**: [Your face OR split screen with diagrams]

**Script**:
```
"Let me explain why this works:

[Technical explanation]
'The reason this fixes the problem is [explanation].

[How it works]
'When [trigger], now [correct behavior] instead of [old broken behavior].'

[Diagram if helpful]
'Here's a diagram of the flow...'
[Show architecture/flow diagram]

[Why the bug happened]
'The original bug happened because [root cause explanation].'

[Prevention]
'To prevent this in the future:
1. [Prevention measure 1]
2. [Prevention measure 2]
3. [Prevention measure 3]'

[Broader lesson]
'The bigger lesson here: [general principle].'

[When to watch for this]
'If you ever see [symptom], check for [this issue].'"
```

**On-Screen Text**:
- Architecture diagram
- Flow chart
- Prevention checklist
- Key takeaway

---

### LESSONS LEARNED (10:00-11:00) - 60 seconds

**Visual**: [Your face]

**Script**:
```
"Key takeaways from this debugging session:

[Technical lessons]
1. [Lesson 1] - [why it matters]
2. [Lesson 2] - [why it matters]
3. [Lesson 3] - [why it matters]

[Process lessons]
'What worked in my debugging:
- [Approach 1]
- [Approach 2]'

'What didn't work:
- [Failed approach 1]
- [Failed approach 2]'

[What you'd do differently]
'If I could do this again, I would [improvement].'

[Tools/techniques]
'The debugging tools that helped:
- [Tool 1]
- [Tool 2]'

[Humility]
'Honestly, I should have [earlier realization].'"
```

---

### CALL TO ACTION (11:00-11:30) - 30 seconds

**Visual**: [Your face OR code on screen]

**Script**:
```
"So that's how I fixed [problem].

[Code availability]
The full fix is on GitHub - link in the description.

[Community]
Have you dealt with [similar issue]? Let me know your solution in the comments.

[Subscribe pitch]
If you want to see more real debugging sessions, hit subscribe.

[Next video tease]
Next time, I'll be [next topic].

Thanks for watching, and happy debugging!"
```

---

## Format Variations

### Real-Time Debug (20-30 minutes)
- Keep everything uncut
- Show full thought process
- Include all dead ends
- Raw and authentic

### Edited Debug Story (8-12 minutes)
- Trim repetition
- Keep key moments
- Build suspense
- Clear narrative arc

### Quick Fix (3-5 minutes)
- Skip investigation details
- Jump to solution
- Explain why it works
- Fast paced

---

## Storytelling Tips

### Build Suspense
```
"I thought I had it figured out..."
"But then something strange happened..."
"This is where it gets interesting..."
"And that's when I realized..."
```

### Show Emotion
```
"This is so frustrating..."
"Wait, what?!"
"Oh no, that made it worse..."
"YES! Finally!"
```

### Keep Viewers Engaged
```
"Stay with me, this gets good..."
"You're not going to believe what I found..."
"The real problem is actually..."
"Here's where it all clicked..."
```

---

## Recording Tips

**During Real Debugging**:
- Record everything (edit later)
- Narrate your thoughts out loud
- Use markers for key moments
- Don't be afraid to show confusion
- Celebrate when you figure it out

**When Re-Creating**:
- Know the solution already
- Build the story arc
- Show realistic struggle
- Include authentic reactions
- Make it educational

---

## On-Screen Text Templates

**Problem Severity**:
```
🔴 CRITICAL
Blocking production deployment

⚠️ HIGH PRIORITY
Affecting 1000+ users

⏰ PERFORMANCE
2000ms → Need <500ms
```

**Debug Status**:
```
Theory #1: [X] ❌
Theory #2: [Y] ❌
Theory #3: [Z] ✅ ROOT CAUSE
```

**Fix Impact**:
```
BEFORE: [old metric]
AFTER: [new metric]
IMPROVEMENT: [percentage] ↑
```

---

## Description Template

```markdown
Debugging [problem] - [timeframe] investigation + the fix

Watch me track down and fix [problem description] that was [impact].

⚠️ THE PROBLEM
[Brief description]
Impact: [what was affected]
Duration: [how long you were stuck]

💡 THE SOLUTION
[Brief solution description]
Result: [improvement]

⏱️ TIMESTAMPS
0:00 - Cold Open (The Problem)
0:45 - Problem Demonstration
2:00 - Investigation Begins
4:00 - Breakthrough Moment
5:00 - The Fix
7:00 - Testing & Verification
8:30 - Technical Explanation
10:00 - Lessons Learned

🔧 KEY TAKEAWAYS
1. [Lesson 1]
2. [Lesson 2]
3. [Lesson 3]

🔗 RESOURCES
GitHub Fix: [link]
Related Documentation: [link]
Debug Tool: [link]

💬 DISCUSSION
Have you experienced [similar problem]?
Share your debugging stories in the comments!

---

#debugging #programming #[technology] #problemsolving #coding
```

---

## Success Metrics

**Good problem-solving video indicators**:
- "I had this exact problem!" comments
- Questions about related issues
- People sharing their solutions
- High watch time (invested in the story)
- Many saves (reference material)
- Technical discussion in comments

---

**Show the real process. Developers appreciate authenticity over perfection.** 🚀

---

**Version**: 1.0.0
**Template Type**: Problem-Solution Video Script
