# Tutorial Video Script Template

**Use this template for**: Step-by-step teaching videos where you walk viewers through implementing something specific.

---

## Video Information

**Title**: [Your Video Title - Be specific and benefit-focused]

**Target Audience**: [Who is this for? Beginner/Intermediate/Advanced developers?]

**Duration Target**: [8-15 minutes recommended for tutorials]

**Key Takeaway**: [What will viewers be able to do after watching?]

**Prerequisites**: [What should viewers already know?]

---

## Script Structure

### HOOK (0:00-0:15) - 15 seconds

**Visual**: [Show the final result first]

**Script**:
```
[Open with the working result - show don't tell]

"Watch me [accomplish specific result] in [time frame]."

[OR alternative hook:]

"By the end of this video, you'll be able to [specific skill/result]."

[Quick preview of what they'll build]
```

**On-Screen Text**:
- Result preview (5 seconds)
- Your name/channel
- Tutorial title

**Example**:
```
[Screen shows: Fast API responding in 180ms]

"Watch me make this API 10x faster using Redis caching."

[Show before: 2000ms, after: 180ms]

"By the end of this video, you'll have a production-ready caching layer."
```

---

### INTRO (0:15-1:00) - 45 seconds

**Visual**: [Your face OR split screen (you + code)]

**Script**:
```
"Hey everyone, [your name] here.

Today we're going to [main goal].

[Why does this matter? What's the problem?]

[What makes your approach unique/better?]

Here's what we'll cover:
1. [Step 1 summary]
2. [Step 2 summary]
3. [Step 3 summary]

Let's dive in."
```

**On-Screen Text**:
- Chapter markers (preview)
- GitHub repo link (if available)
- Prerequisites

**Example**:
```
"Hey everyone, Jeremy here.

Today we're implementing Redis caching to dramatically speed up our API.

If you're tired of slow API response times, this is the solution. We went from 2 seconds to 200 milliseconds per request.

Here's what we'll cover:
1. Installing and configuring Redis
2. Implementing the caching layer
3. Testing and measuring performance

Let's dive in."
```

---

### SETUP (1:00-2:30) - 90 seconds

**Visual**: [Screen recording - terminal + code editor]

**Script**:
```
"First, let's set up our environment.

[Show prerequisites - what's already in place]

You'll need:
- [Requirement 1]
- [Requirement 2]
- [Requirement 3]

[If they can skip setup:]
'If you want to skip the setup, I've linked the starter repo below.'

[Show setup commands - fast but clear]

Let me quickly run through the setup...

[Install dependencies]
[Configure environment]
[Verify everything works]

Great, we're ready to start building."
```

**On-Screen Text**:
- Setup commands (show terminal clearly)
- Links to documentation
- GitHub repo link

**Editing Note**: Fast-forward through any waiting/installation times. Use text overlays for commands.

---

### IMPLEMENTATION PART 1 (2:30-5:30) - 3 minutes

**Visual**: [Screen recording - code editor focus]

**Script**:
```
"Now let's implement [first major component].

[Explain the concept before showing code]
'The way this works is...'

[Show the code, explain line by line for key parts]

[For boilerplate code:]
'I'm going to speed through this boilerplate - you can copy it from the repo.'

[For critical code:]
'This line here is important because...'

[Common mistake callout:]
'Watch out - a common mistake is [X]. Make sure you [Y].'

[Test first implementation]
'Let's test this to make sure it's working...'

[Show result]

Perfect, [first component] is working."
```

**On-Screen Text**:
- Code annotations (highlight important lines)
- Key concepts (definitions)
- Timestamps to GitHub code
- Error warnings

**Editing Note**:
- Zoom in on critical code sections
- Fast-forward through typing boilerplate
- Show terminal output clearly
- Add annotations for key concepts

---

### IMPLEMENTATION PART 2 (5:30-8:30) - 3 minutes

**Visual**: [Screen recording - code editor + browser/Postman]

**Script**:
```
"Now that we have [Part 1] working, let's add [Part 2].

[Build on previous section]
'Remember when we set up [X]? Now we're going to connect it to [Y].'

[Show implementation]

[Explain any complex logic]
'This might look complicated, but here's what's happening...'

[Break down complex parts]
'Let's break this into steps:
1. [Step 1]
2. [Step 2]
3. [Step 3]'

[Show testing]
'Let's see this in action...'

[Demonstrate working feature]

Awesome, everything is connected."
```

**On-Screen Text**:
- Architecture diagram (if helpful)
- Code flow arrows
- Test results
- Performance metrics

---

### IMPLEMENTATION PART 3 (8:30-11:00) - 2.5 minutes

**Visual**: [Screen recording - full demonstration]

**Script**:
```
"Finally, let's add [finishing touches/optimization/error handling].

[Why this final step matters]
'This is important for production because...'

[Implement final piece]

[Best practices callout]
'In a real application, you'd also want to [additional considerations].'

[Full demonstration]
'Let's see the complete implementation...'

[Run through entire feature]

[Show before/after if applicable]
'Remember where we started? [Show before state]
And now... [Show after state]'

[Highlight the improvement]
'That's a [X]x improvement!'"
```

**On-Screen Text**:
- Before/after comparison
- Performance metrics
- Best practices checklist

---

### RECAP (11:00-12:00) - 60 seconds

**Visual**: [Your face OR split screen]

**Script**:
```
"Let's quickly recap what we built:

[Quick summary of each part]
1. We set up [X]
2. We implemented [Y]
3. We optimized with [Z]

[Key learnings]
The main takeaways are:
- [Lesson 1]
- [Lesson 2]
- [Lesson 3]

[Point to resources]
All the code is on GitHub - link in the description.
I've also included helpful resources below."
```

**On-Screen Text**:
- Chapter markers (review)
- GitHub repo link
- Resource links

---

### NEXT STEPS (12:00-12:30) - 30 seconds

**Visual**: [Your face]

**Script**:
```
"Here's what you can do next:

[Challenges/extensions]
Try adding:
- [Challenge 1]
- [Challenge 2]
- [Challenge 3]

If you implement any of these, share them in the comments!

[Next video tease]
In the next video, I'll show you how to [next topic].

[Standard outro]
If this was helpful, don't forget to like and subscribe.

Thanks for watching, and I'll see you in the next one!"
```

**On-Screen Text**:
- Challenge ideas
- Next video preview
- Subscribe button

---

### CALL TO ACTION (12:30-12:45) - 15 seconds

**Visual**: [End screen with elements]

**Script**:
```
[No speaking - end screen music]
```

**On-Screen Elements**:
- Next video (clickable)
- Subscribe button (clickable)
- Playlist/related content
- Social media links

---

## B-Roll Suggestions

**Throughout the video, include:**
- Close-ups of code (important lines)
- Terminal commands executing
- Test results/console output
- Before/after comparisons
- Architecture diagrams
- Your face reacting (excitement when things work!)

---

## On-Screen Text Templates

**Chapter Marker Format**:
```
⏱️ 1:00 - Setup
⏱️ 2:30 - Implementation Part 1
⏱️ 5:30 - Implementation Part 2
⏱️ 8:30 - Finishing Touches
⏱️ 11:00 - Recap
```

**Code Annotation Format**:
```
[Arrow pointing to line]
"This creates the cache connection"

[Highlight block]
"Error handling logic"

[Underline]
"Key optimization here"
```

**Warning/Tip Format**:
```
⚠️ WATCH OUT
Common mistake: [description]

💡 PRO TIP
[helpful tip]

✅ BEST PRACTICE
[best practice]
```

---

## Description Template

```markdown
[Quick summary of what was built]

In this tutorial, I'll show you how to [main goal]. We'll cover [main topics].

⏱️ TIMESTAMPS
0:00 - Hook
0:15 - Introduction
1:00 - Setup
2:30 - [Part 1]
5:30 - [Part 2]
8:30 - [Part 3]
11:00 - Recap
12:00 - Next Steps

🔗 RESOURCES
GitHub Code: [link]
Documentation: [link]
Starter Template: [link]
Related Tutorial: [link]

📚 PREREQUISITES
- [Prerequisite 1]
- [Prerequisite 2]
- [Prerequisite 3]

🎯 CHALLENGES
Try implementing:
1. [Challenge 1]
2. [Challenge 2]
3. [Challenge 3]

Share your results in the comments!

💬 CONNECT
Twitter: [handle]
Discord: [link]
Newsletter: [link]

🎥 NEXT VIDEO
[Next video topic - link in end screen]

---

#tutorial #webdev #[technology] #coding #programming
```

---

## Recording Tips

1. **Preparation**:
   - Test everything before recording
   - Have code ready in stages (don't debug on camera)
   - Clean up desktop/browser tabs
   - Close notifications

2. **While Recording**:
   - Speak clearly and at medium pace
   - Pause between sections (easier to edit)
   - Use markers (`/record mark "description"`)
   - If you make a mistake, pause, then restart sentence

3. **Voice Energy**:
   - Start with high energy (hook)
   - Maintain enthusiasm throughout
   - Emphasize key points
   - Celebrate when things work!

4. **Camera Position** (if using webcam):
   - Eye level with camera
   - Good lighting (face well-lit)
   - Clean background
   - Picture-in-picture in bottom right

---

## Editing Checklist

- [ ] Remove long silences (over 2 seconds)
- [ ] Remove filler words (um, uh, like)
- [ ] Fast-forward through boilerplate/waiting
- [ ] Add code annotations on key lines
- [ ] Add chapter markers in description
- [ ] Add on-screen text for key concepts
- [ ] Include before/after comparisons
- [ ] Add intro/outro animations
- [ ] Add background music (low volume)
- [ ] Add subtitles
- [ ] Color grade for consistent look
- [ ] Add end screen with elements

---

## Common Mistakes to Avoid

1. **Going too fast** - Remember viewers are following along
2. **Skipping explanation** - Explain WHY, not just HOW
3. **Too much detail** - Focus on key concepts, link to docs for details
4. **Not showing results** - Always demonstrate working feature
5. **Missing prerequisites** - State what viewers need upfront
6. **Ignoring errors** - If you hit an error, show how to fix it
7. **Weak hook** - First 15 seconds determine if viewer stays

---

## Success Metrics

**Good tutorial indicators**:
- 50%+ average view duration
- High like ratio (>5%)
- Many "thank you" comments
- Questions asking for more depth
- Saves/bookmarks
- GitHub repo stars

**Red flags**:
- <30% view duration (too long or not engaging)
- Comments asking "but how do you..."
- Confusion about prerequisites
- Many dislikes (unclear or wrong information)

---

## Variations

### Quick Tutorial (5-7 minutes)
- Faster pace
- Less explanation
- For viewers who want to implement quickly

### Deep Dive Tutorial (20-30 minutes)
- Slower pace
- More explanation of concepts
- Multiple examples
- Error handling and edge cases

### Series Tutorial (5-10 videos)
- Break into smaller parts
- Each video builds on previous
- Consistent intro/outro
- Clear "previous/next" links

---

**Use this template every time you create a tutorial. Consistency = growth.** 🚀

---

**Version**: 1.0.0
**Template Type**: Tutorial Video Script
