---
name: profile
description: Profile application performance metrics
---
# Application Profiler

Analyze application performance including CPU usage, memory consumption, execution time, and identify bottlenecks.

## Analysis Steps

1. Identify the application technology stack (Node.js, Python, Java, etc.)
2. Locate main application entry points and critical paths
3. Analyze:
   - CPU-intensive operations and hot paths
   - Memory allocation patterns and potential leaks
   - Synchronous vs asynchronous operations
   - Database query patterns
   - External API calls and network operations
4. Generate profiling report with recommendations

## Output Format

Provide a markdown report with:
- Executive summary of performance characteristics
- CPU hotspots with file locations
- Memory usage patterns
- Execution time breakdown
- Specific optimization recommendations
- Code snippets showing issues and suggested fixes
