---
name: detect-bottlenecks
description: Detect performance bottlenecks in application
---
# Bottleneck Detector

Identify and resolve performance bottlenecks across the application stack.

## Detection Areas

1. **CPU Bottlenecks**: Computation-heavy operations
2. **Memory Bottlenecks**: Memory allocation/deallocation issues
3. **I/O Bottlenecks**: Disk and network operations
4. **Database Bottlenecks**: Query performance issues
5. **Lock Contention**: Synchronization overhead
6. **Resource Exhaustion**: Connection pools, file descriptors

## Process

1. Analyze application architecture and data flow
2. Identify potential bottleneck locations
3. Review code for common bottleneck patterns
4. Evaluate resource utilization
5. Generate prioritized remediation plan

## Output

Provide comprehensive report with:
- Identified bottlenecks with severity ratings
- Root cause analysis for each bottleneck
- Impact assessment on overall performance
- Specific remediation strategies with code examples
- Monitoring recommendations to prevent recurrence
- Priority order for addressing issues
