---
name: optimize-cache
description: Optimize caching strategies and implementation
---
# Cache Performance Optimizer

Analyze and optimize caching strategies for maximum performance.

## Analysis Areas

1. **Cache Hit Rates**: Identify low cache hit ratios
2. **Cache Keys**: Evaluate key design and granularity
3. **TTL Configuration**: Time-to-live optimization
4. **Cache Invalidation**: Proper invalidation strategies
5. **Cache Warming**: Pre-loading critical data
6. **Cache Layers**: Multi-level caching opportunities
7. **Memory Usage**: Cache size and eviction policies

## Process

1. Locate all caching implementations
2. Analyze cache usage patterns
3. Identify cache misses and inefficiencies
4. Evaluate TTL and invalidation strategies
5. Generate optimization recommendations

## Output

Provide report with:
- Cache inventory and configuration analysis
- Hit rate improvement opportunities
- Key design recommendations
- TTL optimization suggestions
- Multi-level caching strategies
- Code examples for improvements
