---
name: collect-metrics
description: Collect infrastructure performance metrics
---
# Infrastructure Metrics Collector

Set up comprehensive infrastructure metrics collection for performance monitoring.

## Infrastructure Layers

1. **Compute**: CPU, memory, processes, load average
2. **Storage**: Disk I/O, capacity, inode usage
3. **Network**: Bandwidth, connections, packet loss
4. **Containers**: Container resource usage, orchestration metrics
5. **Load Balancers**: Connection rates, health checks
6. **Databases**: Connection pools, replication lag, cache hit rates

## Process

1. Identify infrastructure components
2. Choose metrics collection agent (Prometheus node_exporter, Datadog agent, etc.)
3. Configure metrics collection
4. Set up central aggregation
5. Create infrastructure dashboards
6. Define infrastructure health alerts

## Output

Provide:
- Metrics collection agent configuration
- Infrastructure inventory
- Collection endpoint setup
- Dashboard configurations showing:
  - Resource utilization heatmaps
  - Capacity trending
  - Health status overview
- Alert rules for infrastructure issues
- Integration with existing monitoring stack
