# Clerk Skill Pack

> Claude Code skill pack for Clerk authentication integration (24 skills)

## Installation

```bash
/plugin install clerk-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `clerk-install-auth` | Install and configure Clerk SDK |
| `clerk-hello-world` | First authenticated request |
| `clerk-local-dev-loop` | Local development workflow |
| `clerk-sdk-patterns` | SDK usage patterns |
| `clerk-core-workflow-a` | User sign-up and sign-in flows |
| `clerk-core-workflow-b` | Session management and middleware |
| `clerk-common-errors` | Common error troubleshooting |
| `clerk-debug-bundle` | Debug information collection |
| `clerk-rate-limits` | Rate limiting and quotas |
| `clerk-security-basics` | Security best practices |
| `clerk-prod-checklist` | Production readiness checklist |
| `clerk-upgrade-migration` | SDK version upgrades |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `clerk-ci-integration` | CI/CD pipeline integration |
| `clerk-deploy-integration` | Deployment platform setup |
| `clerk-webhooks-events` | Webhook configuration |
| `clerk-performance-tuning` | Performance optimization |
| `clerk-cost-tuning` | Cost optimization strategies |
| `clerk-reference-architecture` | Architecture patterns |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `clerk-multi-env-setup` | Multi-environment configuration |
| `clerk-observability` | Monitoring and logging |
| `clerk-incident-runbook` | Incident response procedures |
| `clerk-data-handling` | User data management |
| `clerk-enterprise-rbac` | Enterprise SSO and RBAC |
| `clerk-migration-deep-dive` | Auth provider migration |

## Usage

Skills trigger automatically when you discuss Clerk topics. For example:

- "Help me set up Clerk" triggers `clerk-install-auth`
- "Debug this Clerk error" triggers `clerk-common-errors`
- "Deploy my Clerk integration" triggers `clerk-deploy-integration`

## License

MIT
