---
name: "cursor-known-pitfalls"
description: |
  Manage avoid common Cursor IDE pitfalls and mistakes. Triggers on "cursor pitfalls",
  "cursor mistakes", "cursor gotchas", "cursor issues", "cursor problems". Use when working with cursor known pitfalls functionality. Trigger with phrases like "cursor known pitfalls", "cursor pitfalls", "cursor".
allowed-tools: "Read, Write, Edit, Bash(cmd:*)"
version: 1.0.0
license: MIT
author: "Jeremy Longshore <jeremy@intentsolutions.io>"
---

# Cursor Known Pitfalls

## Overview

This skill helps you identify and avoid common Cursor IDE pitfalls and mistakes. It covers AI feature pitfalls, configuration issues, security concerns, and team collaboration problems with practical solutions for each.

## Prerequisites

- Cursor IDE installed and configured
- Active project workspace
- Basic understanding of Cursor features
- Version control system in place

## Instructions

1. Review the pitfalls list for your use case
2. Audit your current Cursor configuration
3. Implement recommended settings and files
4. Test AI features after configuration changes
5. Document team-specific workarounds
6. Schedule regular configuration reviews

## Output

- Awareness of common Cursor pitfalls
- Improved AI suggestion quality
- Better security practices
- Optimized performance configuration
- Team alignment on best practices

## Error Handling

See `{baseDir}/references/errors.md` for comprehensive error handling.

## Examples

See `{baseDir}/references/examples.md` for detailed examples.

## Resources

- [Cursor Best Practices](https://cursor.com/docs/best-practices)
- [Cursor Community Forum](https://forum.cursor.com/)
- [Cursor Discord Community](https://discord.gg/cursor)
