# Ai Feature Pitfalls

## AI Feature Pitfalls

### Over-Trusting AI Output
```
PITFALL:
Accepting AI suggestions without review.
AI can generate plausible but incorrect code.

SOLUTION:
- Always review before accepting
- Test generated code
- Understand what the code does
- Don't accept security-sensitive code blindly
```

### Context Pollution
```
PITFALL:
Long conversations accumulate irrelevant context.
AI responses become less accurate over time.

SOLUTION:
- Start new chat for new topics (Cmd+Shift+L)
- Keep conversations focused
- Clear context when switching tasks
- Use @-mentions strategically
```

### Vague Prompts
```
PITFALL:
"Make it better" or "Fix this" without specifics.
AI can't read your mind.

SOLUTION:
- Be specific about what you want
- Include error messages
- Describe expected vs actual behavior
- Provide context with @-mentions
```

### Wrong Model for Task
```
PITFALL:
Using GPT-4 for simple completions (slow, expensive).
Using GPT-3.5 for complex architecture (insufficient).

SOLUTION:
- GPT-3.5/Cursor-small: Simple completions
- GPT-4 Turbo: Complex tasks, large context
- Claude: Explanations, documentation
- Match model to task complexity
```