# Kling AI Skill Pack

Flagship+ skill pack for [Kling AI](https://klingai.com/) - the leading AI video generation platform offering text-to-video, image-to-video, and video extension capabilities.

## What's Included

30 production-ready skills organized into 5 categories:

### Onboarding & Foundations (6 skills)
- **klingai-install-auth** - API authentication and key setup
- **klingai-hello-world** - Your first video generation
- **klingai-model-catalog** - Available models and capabilities
- **klingai-sdk-patterns** - SDK integration patterns
- **klingai-text-to-video** - Text prompt to video basics
- **klingai-pricing-basics** - Credit system and costs

### Operations & Debugging (6 skills)
- **klingai-common-errors** - Error diagnosis and fixes
- **klingai-debug-bundle** - Logging and debugging setup
- **klingai-rate-limits** - Rate limit handling
- **klingai-job-monitoring** - Job status tracking
- **klingai-prod-checklist** - Production readiness
- **klingai-upgrade-migration** - Version migrations

### CI/CD & Deployment (6 skills)
- **klingai-webhook-config** - Webhook notifications
- **klingai-batch-processing** - Bulk video generation
- **klingai-async-workflows** - Async job patterns
- **klingai-storage-integration** - Cloud storage setup
- **klingai-ci-integration** - CI/CD pipelines
- **klingai-reference-architecture** - Production architecture

### Enterprise & Compliance (6 skills)
- **klingai-team-setup** - Team and org management
- **klingai-cost-controls** - Budget and spending limits
- **klingai-usage-analytics** - Usage tracking
- **klingai-content-policy** - Content moderation
- **klingai-audit-logging** - Audit trails
- **klingai-compliance-review** - Security review

### Advanced Patterns (6 skills)
- **klingai-image-to-video** - Image animation
- **klingai-video-extension** - Extend video duration
- **klingai-camera-control** - Camera movements
- **klingai-style-transfer** - Style and effects
- **klingai-performance-tuning** - Optimization
- **klingai-known-pitfalls** - Common mistakes

## Installation

### Claude Code Plugin
```bash
/plugin install klingai-pack@claude-code-plugins-plus
```

### npm Package
```bash
npm install @intentsolutionsio/klingai-skill-md-pack
```

## Quick Start

1. Get your API key from [Kling AI](https://klingai.com/)
2. Set environment variable:
   ```bash
   export KLINGAI_API_KEY="your-api-key"
   ```
3. Start using skills in Claude Code

## Requirements

- Kling AI account with API access
- API key with sufficient credits

## Resources

- [Kling AI Documentation](https://docs.klingai.com/)
- [Kling AI API Reference](https://docs.klingai.com/api)
- [Kling AI Pricing](https://klingai.com/pricing)

## License

MIT License - see [LICENSE](LICENSE) for details.
