# Linear Skill Pack

> Claude Code skill pack for Linear integration (24 skills)

## Installation

```bash
/plugin install linear-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `linear-install-auth` | Install and configure Linear SDK/CLI authentication |
| `linear-hello-world` | Create your first issue and query with Linear API |
| `linear-local-dev-loop` | Set up local Linear development and testing workflow |
| `linear-sdk-patterns` | TypeScript/JavaScript SDK patterns and best practices |
| `linear-core-workflow-a` | Issue lifecycle management (create, update, transition) |
| `linear-core-workflow-b` | Project and cycle management workflows |
| `linear-common-errors` | Diagnose and fix common Linear API errors |
| `linear-debug-bundle` | Comprehensive debugging toolkit for Linear integrations |
| `linear-rate-limits` | Handle Linear API rate limiting and quotas |
| `linear-security-basics` | Secure API key management and OAuth best practices |
| `linear-prod-checklist` | Production readiness checklist for Linear integrations |
| `linear-upgrade-migration` | Upgrade Linear SDK versions and migrate breaking changes |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `linear-ci-integration` | GitHub Actions and CI/CD pipeline integration |
| `linear-deploy-integration` | Deploy Linear-integrated applications |
| `linear-webhooks-events` | Configure and handle Linear webhooks |
| `linear-performance-tuning` | Optimize Linear API queries and caching |
| `linear-cost-tuning` | Optimize API usage and manage costs |
| `linear-reference-architecture` | Production-grade Linear integration patterns |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `linear-multi-env-setup` | Configure Linear across dev/staging/prod environments |
| `linear-observability` | Monitoring, logging, and alerting for Linear integrations |
| `linear-incident-runbook` | Production incident response procedures |
| `linear-data-handling` | Data sync, backup, and consistency patterns |
| `linear-enterprise-rbac` | Enterprise role-based access control with Linear |
| `linear-migration-deep-dive` | Migrate from Jira, Asana, or other tools to Linear |

## Usage

Skills trigger automatically when you discuss Linear topics. For example:

- "Help me set up Linear" -> triggers `linear-install-auth`
- "Debug this Linear error" -> triggers `linear-common-errors`
- "Deploy my Linear integration" -> triggers `linear-deploy-integration`
- "Migrate from Jira to Linear" -> triggers `linear-migration-deep-dive`

## About Linear

Linear is a modern issue tracking and project management tool built for software teams. It features:
- Fast, keyboard-driven interface
- Cycles and roadmaps for sprint planning
- Powerful GraphQL API
- GitHub, GitLab, and Slack integrations
- Team workspaces and custom workflows

## License

MIT
