---
name: generating-compliance-reports
description: Generate comprehensive compliance reports for security standards. Use when creating compliance documentation. Trigger with 'generate compliance report', 'compliance status', or 'audit compliance'.
version: 1.0.0
allowed-tools: "Read, Write, Edit, Grep, Glob, Bash(security:*), Bash(scan:*), Bash(audit:*)"
license: MIT
author: Jeremy Longshore <jeremy@intentsolutions.io>
---
# Compliance Report Generator

This skill provides automated assistance for compliance report generator tasks.

## Overview

This skill empowers Claude to create detailed compliance reports, saving time and ensuring accuracy in documenting security practices. It automates the process of gathering information and formatting it into a standardized report, making compliance audits easier and more efficient.

## How It Works

1. **Identify Report Type**: Claude analyzes the user's request to determine the required compliance standard (e.g., PCI DSS, HIPAA).
2. **Gather Data**: The plugin collects relevant data from the system or prompts the user for necessary information.
3. **Generate Report**: The plugin formats the collected data into a comprehensive compliance report, including necessary sections and documentation.

## When to Use This Skill

This skill activates when you need to:
- Generate a report for a specific compliance standard (e.g., "generate a HIPAA compliance report").
- Create a security audit report.
- Document adherence to a security policy.
- Prepare for a compliance audit.

## Examples

### Example 1: Generating a PCI DSS Compliance Report

User request: "Generate a PCI DSS compliance report for our e-commerce platform."

The skill will:
1. Activate the compliance-report-generator plugin.
2. Prompt the user for information about their e-commerce platform's security controls and processes.
3. Generate a detailed PCI DSS compliance report based on the provided information.

### Example 2: Creating a HIPAA Compliance Report

User request: "Create a HIPAA compliance report to demonstrate our adherence to privacy regulations."

The skill will:
1. Activate the compliance-report-generator plugin.
2. Guide the user through a series of questions related to HIPAA requirements.
3. Compile the answers into a structured HIPAA compliance report.

## Best Practices

- **Specificity**: Be specific about the compliance standard you need a report for (e.g., "SOC 2 report").
- **Completeness**: Provide all the necessary information requested by the plugin to ensure a comprehensive and accurate report.
- **Review**: Always review the generated report to ensure its accuracy and completeness before submitting it for an audit.

## Integration

This skill can be integrated with other plugins that provide security assessment or vulnerability scanning capabilities. The results from those plugins can be incorporated into the compliance reports generated by this skill, providing a more comprehensive view of the organization's security posture.

## Prerequisites

- Access to codebase and configuration files in {baseDir}/
- Security scanning tools installed as needed
- Understanding of security standards and best practices
- Permissions for security analysis operations

## Instructions

1. Identify security scan scope and targets
2. Configure scanning parameters and thresholds
3. Execute security analysis systematically
4. Analyze findings for vulnerabilities and compliance gaps
5. Prioritize issues by severity and impact
6. Generate detailed security report with remediation steps

## Output

- Security scan results with vulnerability details
- Compliance status reports by standard
- Prioritized list of security issues by severity
- Remediation recommendations with code examples
- Executive summary for stakeholders

## Error Handling

If security scanning fails:
- Verify tool installation and configuration
- Check file and directory permissions
- Validate scan target paths
- Review tool-specific error messages
- Ensure network access for dependency checks

## Resources

- Security standard documentation (OWASP, CWE, CVE)
- Compliance framework guidelines (GDPR, HIPAA, PCI-DSS)
- Security scanning tool documentation
- Vulnerability remediation best practices
