---
name: pentest
description: Run a security testing workflow against a target URL or codebase
shortcut: pent
---

# Security Testing Workflow

Run a structured security assessment. This command walks through authorization,
scope selection, scanning, and reporting.

## Step 1: Authorization Check

Before scanning anything, confirm authorization:

- If the target is a URL: ask the user to confirm they own it or have written
  permission to test it.
- If the target is local code/dependencies: confirm it is the user's own project.
- **Do not proceed without explicit authorization.**

## Step 2: Determine Scope

Ask the user what they want to test:

1. **Web application** (URL) -- security headers, SSL, exposed endpoints, CORS
2. **Dependencies** (project directory) -- npm/pip vulnerability audit
3. **Source code** (directory) -- static analysis for secrets, injection, etc.
4. **Full audit** -- all of the above

## Step 3: Run Scanners

Based on the selected scope, run the appropriate scripts from the plugin:

### Web Application Scan
```bash
python3 ${CLAUDE_PLUGIN_ROOT}/skills/performing-penetration-testing/scripts/security_scanner.py TARGET_URL --verbose
```

### Dependency Audit
```bash
python3 ${CLAUDE_PLUGIN_ROOT}/skills/performing-penetration-testing/scripts/dependency_auditor.py TARGET_DIR --verbose
```

### Code Security Scan
```bash
python3 ${CLAUDE_PLUGIN_ROOT}/skills/performing-penetration-testing/scripts/code_security_scanner.py TARGET_DIR --verbose
```

Save JSON reports for any scan that finds critical or high issues:
```bash
python3 SCANNER --output /tmp/security-report-$(date +%Y%m%d).json
```

## Step 4: Present Findings

Summarize results for the user:

1. **Summary table** -- total findings by severity across all scanners
2. **Critical/High findings** -- detail each one with the risk and impact
3. **Remediation priorities** -- ordered list of what to fix first

## Step 5: Suggest Remediations

For each critical and high finding:

1. Explain the vulnerability in plain language
2. Provide the specific fix (reference REMEDIATION_PLAYBOOK.md)
3. Show how to verify the fix

Offer to apply code fixes directly for code-level findings.

## Step 6: Generate Report

If the user wants a saved report, combine all findings into a single JSON file:
```bash
# Reports are saved via the --output flag on each scanner
```

## Safety Rules

- Never run scans against unauthorized targets
- All scanners use safe, non-destructive techniques (GET requests, static analysis)
- No exploit payloads are sent to targets
- No data is exfiltrated or modified
