# Test Data Generator Plugin

Generate realistic test data including users, products, orders, and custom schemas for comprehensive testing.

## Features

- **Realistic data** - Names, emails, addresses, phone numbers
- **Business data** - Products, orders, invoices, transactions
- **Technical data** - UUIDs, IPs, URLs, tokens
- **Custom schemas** - JSON Schema, TypeScript, GraphQL
- **Bulk generation** - Create thousands of records
- **Locale support** - Data for different regions
- **Deterministic** - Reproducible with seeds

## Installation

```bash
/plugin install test-data-generator@claude-code-plugins-plus
```

## Usage

```
Generate 100 test users with addresses
Create e-commerce test data (products, orders, customers)
Generate API test data matching our OpenAPI schema
```

## Data Types

- **Users** - Names, emails, passwords, addresses, profiles
- **Products** - Names, descriptions, prices, categories
- **Orders** - Items, totals, status, shipping
- **Companies** - Names, addresses, domains, employees
- **Custom** - Your schema, your data

## License

MIT
