# Apollo Skill Pack

> Claude Code skill pack for Apollo.io sales intelligence platform (24 skills)

## Installation

```bash
/plugin install apollo-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `apollo-install-auth` | Install and configure Apollo API authentication |
| `apollo-hello-world` | Create a minimal working Apollo example |
| `apollo-local-dev-loop` | Configure Apollo local development workflow |
| `apollo-sdk-patterns` | Apply production-ready Apollo SDK patterns |
| `apollo-core-workflow-a` | Implement lead search and enrichment workflow |
| `apollo-core-workflow-b` | Implement email sequences and outreach workflow |
| `apollo-common-errors` | Diagnose and fix common Apollo API errors |
| `apollo-debug-bundle` | Collect Apollo debug evidence for support |
| `apollo-rate-limits` | Implement Apollo rate limiting and backoff |
| `apollo-security-basics` | Apply Apollo API security best practices |
| `apollo-prod-checklist` | Execute Apollo production deployment checklist |
| `apollo-upgrade-migration` | Plan and execute Apollo SDK upgrades |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `apollo-ci-integration` | Configure Apollo CI/CD integration |
| `apollo-deploy-integration` | Deploy Apollo integrations to production |
| `apollo-webhooks-events` | Implement Apollo webhook handling |
| `apollo-performance-tuning` | Optimize Apollo API performance |
| `apollo-cost-tuning` | Optimize Apollo costs and credit usage |
| `apollo-reference-architecture` | Implement Apollo reference architecture |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `apollo-multi-env-setup` | Configure Apollo multi-environment setup |
| `apollo-observability` | Set up Apollo monitoring and observability |
| `apollo-incident-runbook` | Apollo incident response procedures |
| `apollo-data-handling` | Apollo data management and compliance |
| `apollo-enterprise-rbac` | Enterprise role-based access control |
| `apollo-migration-deep-dive` | Comprehensive Apollo migration strategies |

## Usage

Skills trigger automatically when you discuss Apollo topics. For example:

- "Help me set up Apollo API" -> triggers `apollo-install-auth`
- "Search for leads in Apollo" -> triggers `apollo-core-workflow-a`
- "Debug this Apollo error" -> triggers `apollo-common-errors`
- "Deploy my Apollo integration" -> triggers `apollo-deploy-integration`

## About Apollo.io

Apollo is a B2B sales intelligence and engagement platform that provides:
- Contact and company database with 275M+ contacts
- Lead search and enrichment APIs
- Email sequencing and outreach automation
- CRM integrations (Salesforce, HubSpot, etc.)
- Intent data and buying signals

## License

MIT
