# Implementation Guide

### Step 1: Access Project Memories
Retrieve stored memories from previous sessions:
1. Locate memory file using Read tool
2. Parse JSON structure containing memory entries
3. Identify relevant memories based on current context
4. Extract applicable decisions, conventions, or preferences

### Step 2: Apply Memories to Current Context
Integrate past decisions into current work:
- Use remembered library/tool choices when making similar decisions
- Apply architectural patterns established in prior sessions
- Reference user preferences for coding style or conventions
- Consider past decisions as context for new features

### Step 3: Update Memories When Needed
Store new decisions for future reference:
- Add significant architectural choices
- Document tool or library selections with rationale
- Record user preferences and conventions
- Update changed decisions to avoid conflicts

### Step 4: Resolve Memory Conflicts
Handle situations where memories conflict with current requests:
- Prioritize current explicit user requests over stored memories
- Flag conflicts for user awareness when appropriate
- Update memories that have become outdated
- Remove memories that are no longer relevant