---
name: metadata
description: Generate SEO-optimized metadata for YouTube, blogs, and social platforms...
---
# SEO Metadata Generator Command

Generate search-optimized metadata (descriptions, tags, keywords) for maximum discoverability across platforms.

## Usage

```bash
/metadata "[video title]"                     # Generate YouTube metadata
/metadata blog "[article title]"              # Generate blog SEO
/metadata social "[post content]"             # Generate social media metadata
/metadata analyze "[url]"                     # Analyze competitor metadata
/metadata keywords "[topic]"                  # Research keywords
```

## Purpose

Create metadata that:
- **Ranks in search** - Target high-volume keywords
- **Drives organic traffic** - SEO-optimized descriptions
- **Improves discoverability** - Platform algorithms favor it
- **Converts viewers** - Compelling calls-to-action
- **Builds authority** - Consistent branding and links

## Metadata Generation

When user runs `/metadata "I Made My API 11x Faster (Redis Tutorial)"`:

**Step 1: Keyword Research**
```
🔍 KEYWORD RESEARCH

Primary Topic: API performance optimization with Redis

Target Keywords (Ranked by Opportunity):

High Volume + Low Competition ✓
├─ "redis caching tutorial" (3,200/month, Competition: 24/100)
├─ "make api faster" (5,400/month, Competition: 31/100)
├─ "api performance optimization" (2,900/month, Competition: 28/100)
└─ "redis tutorial" (8,100/month, Competition: 42/100)

Medium Volume + Low Competition
├─ "redis node.js" (1,800/month, Competition: 19/100)
├─ "api caching" (1,200/month, Competition: 22/100)
├─ "improve api response time" (950/month, Competition: 18/100)
└─ "redis cache example" (720/month, Competition: 15/100)

Long-tail Keywords (Easy wins)
├─ "how to use redis for caching" (480/month, Competition: 12/100)
├─ "api performance best practices" (390/month, Competition: 14/100)
├─ "redis caching strategy" (310/month, Competition: 9/100)
└─ "speed up api with redis" (220/month, Competition: 8/100)

Related Questions People Ask:
├─ "How does Redis improve performance?" (890/month)
├─ "Is Redis faster than database?" (650/month)
├─ "When to use Redis caching?" (540/month)
└─ "How to implement Redis caching?" (720/month)

Recommendation: Target "make api faster" + "redis caching tutorial"
Combined monthly search: 8,600
Ranking difficulty: Medium (32/100)
```

**Step 2: Description Generation**
```
📝 YOUTUBE DESCRIPTION

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

I Made My API 11x Faster (Redis Tutorial)

In this video, I'll show you exactly how I improved my API performance from 2000ms to 180ms using Redis caching - an 11x speed improvement in just 1 hour of work.

🎯 What You'll Learn:
├─ Why your API is slow (common bottlenecks)
├─ How Redis caching works (simple explanation)
├─ Step-by-step Redis implementation (15 minutes)
├─ Before/after performance comparison
└─ Production-ready code examples

⏱️ Timestamps:
00:00 - Introduction
00:45 - The Performance Problem
02:15 - Why Redis is the Solution
04:30 - Installing and Setting Up Redis
07:20 - Implementation (Code Walkthrough)
12:40 - Testing the Performance Improvement
14:15 - Production Deployment Tips
16:30 - Results and Key Takeaways

💻 Code & Resources:
├─ GitHub Repo: [your-repo-link]
├─ Redis Documentation: https://redis.io/docs
├─ Blog Post Version: [your-blog-link]
└─ Free Redis Course: [course-link]

🔧 Tools Used:
- Node.js 18+
- Redis 7.0
- ioredis npm package
- Express.js

📈 Performance Results:
Before: 2000ms average response time
After: 180ms average response time
Improvement: 11x faster (91% reduction)

🎓 Related Videos:
├─ Database Optimization: [link]
├─ API Best Practices: [link]
└─ Redis vs Memcached: [link]

💬 Questions? Drop them in the comments!

🔔 Subscribe for more API optimization tutorials, performance tips, and web development content!

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

#redis #api #performance #webdev #nodejs #tutorial #coding #programming #developer #caching

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

SEO Optimization Score: 9.2/10
Keyword Density: Optimal (2.3%)
Call-to-Action: Present ✓
Links: 6 relevant links ✓
Timestamps: Included ✓
Hashtags: 10 targeted tags ✓
```

**Step 3: Tags Generation**
```
🏷️ YOUTUBE TAGS

Primary Tags (Use all 500 characters):

Core Topic Tags:
redis, redis tutorial, redis caching, api performance, api optimization, make api faster, improve api speed, api caching, caching tutorial, redis nodejs

Technical Tags:
nodejs, express js, javascript, backend development, web development, database optimization, performance optimization, system design, scalability, microservices

Audience Intent Tags:
tutorial, how to, step by step, beginner friendly, code along, full tutorial, programming tutorial, web dev tutorial

Result/Benefit Tags:
faster api, speed up api, improve performance, 10x faster, performance boost, quick wins, api best practices

Format Tags:
coding tutorial, tech tutorial, programming, developer, software engineering, code walkthrough, live coding

Long-tail Tags:
how to use redis for caching, redis caching nodejs, api performance nodejs, improve api response time, redis cache implementation, redis caching strategy

Trending/Viral Tags:
tech, coding, programming, developer life, build in public

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Character Count: 487/500 ✓
Tag Count: 45 tags
Relevance Score: 9.4/10
Competition: Low-Medium

Recommended: Use first 30 tags for best balance
```

**Step 4: Additional Metadata**
```
🎬 ADDITIONAL METADATA

Category: Science & Technology ✓

Playlist Suggestions:
├─ "API Performance Series"
├─ "Redis Tutorials"
├─ "Backend Development"
└─ "Quick Wins for Developers"

Thumbnail Text Recommendation:
"11x FASTER API" (large, bold)
"In 1 Hour" (secondary text)

End Screen Elements:
├─ Best for Viewer: "Why Your API is Slow"
├─ Recent Upload: [latest video]
├─ Subscribe Button: Positioned center-right
└─ Playlist: "API Performance Series"

Cards (Add during video):
├─ 02:30 - Link to Redis installation guide
├─ 07:45 - Link to GitHub repo
├─ 12:00 - Link to related video
└─ 15:30 - Subscribe reminder

Captions/Subtitles:
✓ Auto-generate with YouTube
✓ Upload manual SRT for accuracy
✓ Add translated versions (ES, FR, DE)

Community Tab Post (After Upload):
"New video! I made my API 11x faster using Redis.
Link in bio 👆

What's YOUR slowest API endpoint? Drop it below 👇"
```

## Advanced Features

### Blog Post SEO

Generate metadata for blog posts:

```bash
/metadata blog "How to Make Your API 11x Faster with Redis Caching"
```

```
📄 BLOG POST SEO METADATA

Title Tag (60 characters):
"How to Make Your API 11x Faster with Redis Caching"

Meta Description (155 characters):
"Learn how to improve API performance from 2000ms to 180ms using Redis caching. Step-by-step tutorial with code examples. 11x speed boost in 1 hour."

URL Slug:
/make-api-11x-faster-redis-caching

Primary Keyword: "make api faster"
└─ Density: 1.8% (target: 1-2%) ✓

Secondary Keywords:
├─ redis caching (4 mentions)
├─ api performance (6 mentions)
├─ improve api speed (3 mentions)
└─ caching tutorial (2 mentions)

Header Structure:
H1: How to Make Your API 11x Faster with Redis Caching
H2: Why Your API is Slow (The Real Problem)
H2: What is Redis and Why It's Perfect for Caching
H2: Step-by-Step Implementation Guide
  H3: 1. Install Redis
  H3: 2. Set Up Your Node.js Project
  H3: 3. Implement Caching Logic
  H3: 4. Test Your Performance Improvement
H2: Performance Results (Before vs After)
H2: Production Tips and Best Practices
H2: Common Mistakes to Avoid
H2: Conclusion and Next Steps

Internal Links (Add 5-7):
├─ Link to: "API Performance Best Practices"
├─ Link to: "Redis vs Memcached Comparison"
├─ Link to: "Database Optimization Guide"
├─ Link to: "Node.js Performance Tips"
└─ Link to: "Caching Strategies Explained"

External Links (Add 2-3):
├─ Redis Official Documentation
├─ Node.js Best Practices
└─ Web.dev Performance Guide

Image Alt Text:
- Hero image: "API performance graph showing 11x speed improvement with Redis caching"
- Code screenshot: "Node.js code example implementing Redis caching for API"
- Results chart: "Before and after API response time comparison"

Schema Markup (JSON-LD):
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "headline": "How to Make Your API 11x Faster with Redis Caching",
  "datePublished": "2025-01-15",
  "author": {
    "@type": "Person",
    "name": "Your Name"
  },
  "proficiencyLevel": "Intermediate"
}

Estimated Organic Traffic:
├─ Month 1: 50-150 visitors
├─ Month 3: 200-600 visitors
├─ Month 6: 500-1,500 visitors
└─ Year 1: 2,000-5,000 visitors

SEO Score: 91/100 ✓
```

### Social Media Metadata

Generate optimized social media posts:

```bash
/metadata social "redis caching tutorial"
```

```
📱 SOCIAL MEDIA METADATA

━━━ TWITTER/X ━━━

Tweet 1 (Thread Starter):
I just made my API 11x faster in 1 hour 🚀

2000ms → 180ms response time

The secret? Redis caching.

Here's how I did it (with code): 🧵👇

[Include video thumbnail or gif]

Best Time to Post: Tuesday/Wednesday, 10am-2pm EST
Hashtags: #webdev #api #redis #coding (max 4)
Estimated Reach: 5K-20K impressions

━━━ LINKEDIN ━━━

Post:
💡 How I Improved API Performance by 1,100%

I recently optimized an API endpoint that was responding in 2000ms. After implementing Redis caching, it now responds in 180ms.

That's an 11x speed improvement - and it took less than 1 hour to implement.

🎯 Key Takeaways:
• Redis is incredibly fast (sub-millisecond access)
• In-memory caching beats database queries every time
• Small optimizations = massive user experience improvements
• Performance improvements directly impact revenue

🔧 Technical Stack:
- Node.js + Express
- Redis 7.0
- ioredis client

I created a full tutorial walking through the implementation. Link in comments 👇

What's your go-to strategy for API performance?

#WebDevelopment #API #Performance #Redis #BackendDevelopment

Best Time to Post: Tuesday-Thursday, 8am-10am EST
Expected Engagement: 200-1,000 reactions
Expected Views: 3K-15K

━━━ INSTAGRAM/TIKTOK ━━━

Caption:
I made my API 11x faster in 1 hour 🚀⚡

The secret? Redis caching 🔥

Swipe for the before/after →

Full tutorial on YouTube (link in bio)

#coding #programming #webdev #api #redis #tutorial #developer #tech #learntocode #100daysofcode

Best Time to Post: Evenings (7pm-10pm) or lunch (12pm-2pm)
Hashtags: 8-10 relevant tags
Expected Reach: 2K-10K views

━━━ REDDIT ━━━

Subreddits: r/webdev, r/node, r/programming

Title:
"I made my API 11x faster by implementing Redis caching (tutorial with code)"

Post Body:
Hey r/webdev,

I've been working on optimizing a slow API endpoint (2000ms response time) and just got it down to 180ms using Redis caching.

I put together a tutorial showing exactly how I did it, including all the code and gotchas I ran into.

[Link to YouTube video]

[Link to GitHub repo with code]

Some quick stats:
- Before: 2000ms avg response
- After: 180ms avg response
- Implementation time: ~1 hour
- Tech stack: Node.js, Express, Redis

Happy to answer any questions about the implementation!

Best Time to Post: Weekday mornings (9am-11am EST)
Subreddit Rules: Check self-promotion limits
Expected Upvotes: 50-500 (depending on subreddit)
```

### Competitor Analysis

Analyze successful competitors:

```bash
/metadata analyze "https://youtube.com/watch?v=competitor-video"
```

```
🔍 COMPETITOR METADATA ANALYSIS

Video: "API Performance Optimization"
Views: 450K | Uploaded: 6 months ago
Channel: [Competitor Name] (250K subs)

━━━ DESCRIPTION ANALYSIS ━━━

Length: 847 characters ✓ (optimal: 800-1000)
Links: 7 (optimal: 5-8) ✓
Timestamps: Yes ✓
CTAs: 3 (subscribe, comment, GitHub)
Keyword density: 2.1% ✓

Effective Elements:
✓ Clear value proposition in first 2 lines
✓ Timestamp breakdown
✓ Multiple resource links
✓ Related video suggestions
✓ Clear call-to-action

Missing Elements:
❌ No hashtags
❌ No social media links
❌ No email list CTA

━━━ TAG ANALYSIS ━━━

Total Tags: 28
Primary Focus: "api optimization", "performance", "nodejs"

High-Performing Tags They Use:
├─ api optimization
├─ nodejs tutorial
├─ backend development
├─ coding tutorial
└─ web development

Tags They're Missing (Opportunities):
├─ "make api faster" (5.4K searches/month)
├─ "api caching" (1.2K searches/month)
└─ "redis tutorial" (8.1K searches/month)

━━━ RANKING ANALYSIS ━━━

Ranks for:
├─ "api performance" - Position 8
├─ "optimize nodejs api" - Position 12
└─ "api tutorial" - Position 23

Opportunity Keywords (They're not ranking):
├─ "make api faster" - Position: Not ranked
├─ "redis caching" - Position: Not ranked
└─ "api speed optimization" - Position: Not ranked

Your Competitive Advantage:
✓ More specific result (11x faster)
✓ Shorter time commitment (1 hour vs 2+ hours)
✓ Better keyword targeting
✓ More engaging title

Estimated Market Share:
If you optimize correctly: 30-40% of their traffic
Projected views: 135K-180K in 6 months
```

## Platform-Specific Optimization

### YouTube SEO
```
Priority:
1. Title (most important for CTR and ranking)
2. Description (first 200 characters most important)
3. Tags (less important, but still helpful)
4. Captions (helps with accessibility and SEO)
5. Thumbnail (affects CTR, not SEO directly)

Best Practices:
✓ Front-load keywords in title and description
✓ Add timestamps (helps with watch time)
✓ Include 5-8 relevant links
✓ Use all 500 characters for tags
✓ Add video to relevant playlists
✓ Encourage comments (engagement signal)
```

### Google Search SEO (Blog)
```
Priority:
1. Content quality (E-E-A-T: Experience, Expertise, Authority, Trust)
2. On-page SEO (title, headers, keywords, meta description)
3. Internal linking (connect related content)
4. Page speed (Core Web Vitals)
5. Mobile optimization
6. Backlinks (from quality sites)

Best Practices:
✓ Target 1 primary keyword
✓ Include 3-5 secondary keywords
✓ Use keywords in H1, first paragraph, and naturally throughout
✓ Add internal links to 5-7 related posts
✓ Optimize images (compress, add alt text)
✓ Ensure fast load times (<2 seconds)
```

### TikTok/Instagram Discovery
```
Priority:
1. First 3 seconds (hook)
2. Captions (tell viewers what to expect)
3. Hashtags (5-10 relevant tags)
4. Engagement (comments, shares, saves)
5. Audio (trending sounds help)

Best Practices:
✓ Use a mix of popular and niche hashtags
✓ Ask question in caption to drive comments
✓ Add captions/subtitles (85% watch on mute)
✓ Post at peak times (7-10pm)
✓ Encourage saves (algorithm loves saves)
```

### LinkedIn Visibility
```
Priority:
1. First 2 lines (most visible before "see more")
2. Engagement (comments > reactions > shares)
3. Hashtags (3-5 relevant tags)
4. Tags (mention people/companies when relevant)
5. Native video (better reach than YouTube links)

Best Practices:
✓ Hook in first line
✓ Use line breaks for readability
✓ Ask questions to drive comments
✓ Tag relevant people/companies (sparingly)
✓ Post during work hours (8am-10am, 12pm-2pm)
```

## Integration Points

Works with other Creator Studio plugins:

- **viral-idea-generator**: Generate metadata for video ideas
- **title-optimizer**: Optimize titles for SEO
- **analytics-insights**: Track SEO performance
- **distribution-automator**: Apply platform-specific metadata
- **content-calendar-ai**: Schedule SEO-optimized posts

## Best Practices

### Keyword Strategy
1. **One primary keyword per video** - Don't dilute focus
2. **3-5 secondary keywords** - Related topics
3. **Natural language** - Don't stuff keywords unnaturally
4. **Long-tail keywords** - Easier to rank, specific intent
5. **Update older content** - Refresh metadata on old videos

### Description Writing
1. **Front-load value** - First 200 characters matter most
2. **Include timestamps** - Helps with watch time and UX
3. **Add 5-8 links** - Resources, related videos, social
4. **Clear CTAs** - Subscribe, comment, check out resource
5. **Use line breaks** - Make it scannable

### Common Mistakes
❌ Keyword stuffing (hurts more than helps)
❌ Ignoring search intent (targeting wrong keywords)
❌ Copy-pasting same description (looks spammy)
❌ No timestamps (viewers leave faster)
❌ Missing CTAs (missed opportunity for engagement)

Your goal: Make content easily discoverable through search while providing value and driving engagement.
