---
name: optimize-title
description: A/B test video titles for maximum CTR using proven formulas and...
---
# Title Optimizer Command

Optimize video titles for maximum click-through rate using data-driven formulas and A/B testing.

## Usage

```bash
/optimize-title "[your title]"                 # Analyze and improve
/optimize-title generate "[topic]"             # Generate options from topic
/optimize-title test "[title1]" "[title2]"    # A/B test comparison
/optimize-title analyze "[channel-url]"        # Analyze competitor titles
/optimize-title trending                       # Get trending title formats
```

## Purpose

Create titles that:
- **Stop the scroll** - Grab attention in feed
- **Maximize CTR** - Get more clicks per impression
- **Optimize for search** - Rank for target keywords
- **Match audience** - Resonate with your viewers
- **Beat competitors** - Stand out in suggestions

## Title Analysis

When user runs `/optimize-title "How to add Redis caching"`:

**Step 1: Initial Analysis**
```
📊 TITLE ANALYSIS

Original Title: "How to add Redis caching"
Length: 27 characters ✓ (optimal: 40-70)
Word count: 5 words

Issues Found:
❌ Too generic ("How to...")
❌ No hook or intrigue
❌ Missing specifics (time, results)
❌ No power words
❌ Low emotional trigger
❌ Boring, expected

Predicted CTR: 3.2% (Below average 4.5%)
Predicted Views: 5K-15K

Recommendation: Complete rewrite needed
```

**Step 2: Generate Alternatives**
```
✨ OPTIMIZED TITLE OPTIONS (Ranked by Predicted CTR)

OPTION A: "I Made My API 11x Faster in 1 Hour (Redis Tutorial)" ⭐⭐⭐⭐⭐
├─ Predicted CTR: 8.9% (+178% improvement)
├─ Predicted views: 80K-250K
├─ Power words: "Faster" (1)
├─ Specifics: "11x", "1 Hour" (2)
├─ Format: Result + Time + Context
├─ Character count: 56 (optimal)
├─ Psychological triggers: Curiosity, Specific result, Quick win
└─ Why it works: Clear transformation with timeline

OPTION B: "Redis Caching: 2000ms → 180ms in 15 Minutes" ⭐⭐⭐⭐
├─ Predicted CTR: 7.8% (+144% improvement)
├─ Predicted views: 65K-200K
├─ Power words: None (relies on numbers)
├─ Specifics: "2000ms", "180ms", "15 Minutes" (3)
├─ Format: Before → After + Time
├─ Character count: 46
├─ Psychological triggers: Specific metrics, Quick win
└─ Why it works: Concrete before/after comparison

OPTION C: "The Secret to 10x API Performance (Redis)" ⭐⭐⭐⭐
├─ Predicted CTR: 7.2% (+125% improvement)
├─ Predicted views: 55K-160K
├─ Power words: "Secret" (1)
├─ Specifics: "10x" (1)
├─ Format: Mystery + Benefit + Tool
├─ Character count: 43
├─ Psychological triggers: Curiosity gap, Exclusivity
└─ Why it works: Creates mystery, promises specific outcome

OPTION D: "Why Your API is Slow (And How to Fix It Fast)" ⭐⭐⭐⭐
├─ Predicted CTR: 6.8% (+113% improvement)
├─ Predicted views: 50K-140K
├─ Power words: "Fast" (1)
├─ Specifics: None (compensated by relatability)
├─ Format: Problem + Solution
├─ Character count: 48
├─ Psychological triggers: Problem identification, Promise of solution
└─ Why it works: Addresses viewer's pain point directly

OPTION E: "Add Redis Caching in 15 Minutes (Step-by-Step)" ⭐⭐⭐
├─ Predicted CTR: 5.4% (+69% improvement)
├─ Predicted views: 35K-100K
├─ Power words: None
├─ Specifics: "15 Minutes" (1)
├─ Format: Action + Time + Format
├─ Character count: 50
├─ Psychological triggers: Quick win, Structured approach
└─ Why it works: Clear, actionable, time-bound

RECOMMENDATION: Use Option A for maximum viral potential
Alternative: Option B for more technical audience
```

**Step 3: A/B Test Prediction**
```
📈 A/B TEST SIMULATION

Testing: Option A vs Original

Week 1 Projection:
├─ Original Title: 12K impressions → 384 clicks (3.2% CTR)
├─ Option A: 12K impressions → 1,068 clicks (8.9% CTR)
└─ Difference: +684 clicks (+178% improvement)

Month 1 Projection:
├─ Original: 15K views
├─ Option A: 82K views
└─ Difference: +67K views

Revenue Impact (if monetized at $4 CPM):
├─ Original: $60
├─ Option A: $328
└─ Difference: +$268 per video

Recommendation: Option A is clear winner
Confidence: 94%
```

## Title Formulas

### Formula 1: Transformation Story
```
Format: "I [ACTION] [THING] From [BAD] to [GOOD]"

Examples:
✓ "I Made My API 11x Faster in 1 Hour"
✓ "I Built a SaaS From Idea to $10K MRR"
✓ "I Redesigned My Site and Tripled Conversions"

Why It Works:
- Clear transformation
- Specific results
- Relatable journey
- Proves it's possible

Predicted CTR: 7-10%
Best For: Success stories, transformations, tutorials
```

### Formula 2: Number + Outcome
```
Format: "[NUMBER] [THINGS] That [RESULT]"

Examples:
✓ "5 API Optimizations That 10x Your Speed"
✓ "3 Redis Tricks That Changed Everything"
✓ "7 Caching Mistakes Killing Your Performance"

Why It Works:
- Lists are easy to consume
- Specific promise
- Curiosity about each item
- Skimmable content

Predicted CTR: 6-8%
Best For: Tips, lists, compilations
```

### Formula 3: Secret Reveal
```
Format: "The [ADJECTIVE] Secret to [OUTCOME]"

Examples:
✓ "The Simple Secret to 10x API Performance"
✓ "The Hidden Truth About API Caching"
✓ "The Redis Secret Nobody Tells You"

Why It Works:
- Curiosity gap
- Exclusivity feeling
- Promise of inside knowledge
- Mystery to solve

Predicted CTR: 7-9%
Best For: Unique insights, non-obvious solutions
```

### Formula 4: Problem + Solution
```
Format: "Why [PROBLEM] (And How to Fix It)"

Examples:
✓ "Why Your API is Slow (And How to Fix It)"
✓ "Why Caching Fails (And What to Do Instead)"
✓ "Why Redis is Faster (The Science Explained)"

Why It Works:
- Addresses pain point
- Promises solution
- Educational angle
- Relatable problem

Predicted CTR: 6-8%
Best For: Problem-solving, education, debugging
```

### Formula 5: Comparison
```
Format: "[OPTION A] vs [OPTION B]: Which is [BETTER]?"

Examples:
✓ "Redis vs Memcached: Which is Faster?"
✓ "Database vs Cache: Speed Test Results"
✓ "In-Memory vs Disk Cache: The Showdown"

Why It Works:
- Settles a debate
- Data-driven interest
- Takes a position
- Helps decision-making

Predicted CTR: 6-8%
Best For: Tool comparisons, benchmarks, reviews
```

### Formula 6: Time Challenge
```
Format: "[DO THING] in [SHORT TIME]"

Examples:
✓ "Add Redis Caching in 15 Minutes"
✓ "Optimize Your API in Under 1 Hour"
✓ "Build a Cache Layer in 30 Minutes"

Why It Works:
- Time-bound promise
- Quick win appeal
- Achievable goal
- Urgency factor

Predicted CTR: 5-7%
Best For: Tutorials, quick wins, introductions
```

### Formula 7: Mistake/Warning
```
Format: "Stop [DOING WRONG THING] (Do This Instead)"

Examples:
✓ "Stop Caching Wrong (Do This Instead)"
✓ "You're Using Redis Wrong (Here's Why)"
✓ "Never Cache This (Serious Mistake)"

Why It Works:
- Corrects misconception
- Makes viewer feel smart
- Prevents pain
- Authoritative

Predicted CTR: 6-8%
Best For: Corrections, best practices, warnings
```

## Power Words

### High-Impact Words (Use Sparingly)
```
Action Words:
✓ Destroyed, Crushed, Dominated, Mastered
✓ Hacked, Cracked, Unlocked, Revealed
✓ Transformed, Revolutionized, Changed

Result Words:
✓ Faster, Better, Easier, Simpler
✓ Secret, Hidden, Unknown, Surprising
✓ Proven, Guaranteed, Tested, Verified

Emotion Words:
✓ Amazing, Incredible, Shocking, Unbelievable
✓ Brutal, Honest, Truth, Reality
✓ Perfect, Ultimate, Complete, Total

Numbers:
✓ Specific: 11x, 2000ms, 180ms
✓ Ranges: 10-15 minutes, $0-$100K
✓ Percentages: 300% faster, 50% cheaper
```

### Words to Avoid
```
Weak Words:
❌ "Tips", "Tricks" (overused, weak)
❌ "Simple", "Easy" (not believable)
❌ "Best" (subjective, clickbait)
❌ "Learn", "Tutorial" (boring)

Clickbait Words:
❌ "You Won't Believe..."
❌ "This One Weird Trick..."
❌ "Doctors Hate Him..."
❌ "Number 7 Will Shock You..."
```

## Advanced Features

### Competitor Analysis

Analyze successful titles in your niche:

```bash
/optimize-title analyze "https://youtube.com/@fireship"
```

```
🔍 COMPETITOR ANALYSIS

Channel: Fireship
Subscribers: 2.8M
Average Views: 500K-2M per video

Top Performing Title Patterns:

Pattern 1: "X in 100 Seconds" (8 videos)
├─ Average views: 1.2M
├─ Average CTR: 11.3%
├─ Your adaptation: "Redis Caching in 100 Seconds"

Pattern 2: "X was a mistake" (5 videos)
├─ Average views: 900K
├─ Average CTR: 9.8%
├─ Your adaptation: "Database Caching was a Mistake"

Pattern 3: "Why X is Better Than Y" (12 videos)
├─ Average views: 750K
├─ Average CTR: 8.9%
├─ Your adaptation: "Why Redis is Better Than Memcached"

Common Elements:
✓ Short titles (30-50 characters)
✓ Technical topics made accessible
✓ Controversial or strong opinions
✓ Clear value proposition
✓ Number or time in title (60%)

Recommendations:
- Adopt "in 100 seconds" format
- Use strong opinions ("X is better")
- Keep titles under 50 characters
- Technical but accessible
```

### Trending Title Formats

Get current trending formats:

```bash
/optimize-title trending
```

```
📈 TRENDING TITLE FORMATS (This Week)

1. "I spent $X on Y" (Very Hot 🔥)
   └─ Your version: "I Spent $0 Making My API 10x Faster"
   └─ Trend duration: 2-4 weeks
   └─ Predicted CTR: 9.2%

2. "I tried X for Y days" (Hot 🔥)
   └─ Your version: "I Used Redis for 30 Days (Results)"
   └─ Trend duration: 4-6 weeks
   └─ Predicted CTR: 7.8%

3. "The brutal truth about X" (Medium 🌡️)
   └─ Your version: "The Brutal Truth About API Performance"
   └─ Trend duration: Evergreen
   └─ Predicted CTR: 7.2%

4. "X vs Y (I tested both)" (Medium 🌡️)
   └─ Your version: "Redis vs Memcached (I Tested Both)"
   └─ Trend duration: Evergreen
   └─ Predicted CTR: 6.9%

5. "Why I quit X" (Cooling ❄️)
   └─ Your version: "Why I Quit Database Caching"
   └─ Trend duration: Fading fast (1-2 weeks)
   └─ Predicted CTR: 6.5%

Recommendation: Use trend #1 or #2 this week
```

### Title A/B Testing

Compare multiple title options:

```bash
/optimize-title test "Add Redis Caching in 15 Minutes" "I Made My API 11x Faster"
```

```
🆚 A/B TEST COMPARISON

Title A: "Add Redis Caching in 15 Minutes"
├─ Length: 35 characters ✓
├─ Power words: 0
├─ Specifics: "15 Minutes" (1)
├─ Format: Action + Time
├─ Predicted CTR: 5.4%
├─ Predicted views: 35K-100K
└─ Strengths: Clear, actionable, time-bound

Title B: "I Made My API 11x Faster"
├─ Length: 26 characters ⚠️ (could be longer)
├─ Power words: "Faster" (1)
├─ Specifics: "11x" (1)
├─ Format: Personal transformation
├─ Predicted CTR: 8.9%
├─ Predicted views: 80K-250K
└─ Strengths: Specific result, personal story

WINNER: Title B by +65% CTR

Why B Wins:
✓ More emotional (personal story)
✓ Specific metric (11x)
✓ Result-focused vs process-focused
✓ Curiosity gap (how did they do it?)

Improvement for B:
Add context: "I Made My API 11x Faster (Redis Tutorial)"
New predicted CTR: 8.9% → 9.2%
```

## Platform-Specific Optimization

### YouTube
```
Optimal Length: 40-70 characters
Focus: CTR and searchability
Formula: [Hook] + [Context in Parentheses]
Example: "I Made My API 11x Faster (Redis Tutorial)"

Best Practices:
✓ Front-load important words
✓ Add context in parentheses
✓ Use target keyword once
✓ Include numbers when possible
```

### TikTok
```
Optimal Length: 20-40 characters
Focus: Immediate hook
Formula: [Bold Statement]
Example: "I Made My API 11x Faster"

Best Practices:
✓ Short and punchy
✓ First 3 words matter most
✓ Use numbers and specifics
✓ Create curiosity
```

### LinkedIn
```
Optimal Length: 30-60 characters
Focus: Professional credibility
Formula: [Professional Result] + [Methodology]
Example: "11x API Performance Improvement with Redis"

Best Practices:
✓ Professional tone
✓ Business outcomes
✓ Technical but accessible
✓ Avoid clickbait
```

### Twitter
```
Optimal Length: 20-50 characters
Focus: Shareability
Formula: [Surprising Result] or [Hot Take]
Example: "11x Faster APIs in 1 Hour" or "Redis > Databases"

Best Practices:
✓ Bold opinions
✓ Conversation starters
✓ Controversial but defensible
✓ Thread-worthy topics
```

## Integration Points

Works with other Creator Studio plugins:

- **viral-idea-generator**: Generate titles from video ideas
- **thumbnail-designer**: Match thumbnail to title style
- **seo-metadata-generator**: Optimize for search
- **analytics-insights**: Track title performance
- **distribution-automator**: Platform-specific titles

## Best Practices

### Title Writing Rules
1. **Front-load value** - Put hook in first 40 characters
2. **Use specifics** - Numbers, timeframes, metrics
3. **Create curiosity** - Make them want to know more
4. **Be honest** - Never mislead (kills retention)
5. **Test variations** - A/B test everything

### Common Mistakes
❌ Too long (>80 characters - gets cut off)
❌ Too vague ("How to improve performance")
❌ Clickbait without payoff (kills trust)
❌ No hook (boring, expected)
❌ Missing keywords (poor search ranking)

### Testing Strategy
1. **Generate 5-10 options** - Don't settle for first idea
2. **Narrow to top 3** - Based on formula and data
3. **Test with audience** - Poll, tweet, ask
4. **Monitor first 48 hours** - CTR stabilizes quickly
5. **Iterate and improve** - Apply learnings to next video

## Troubleshooting

### Low CTR Despite Good Title
```
⚠️ Title CTR: 3.1% (Expected: 6-8%)

Possible Issues:
- Thumbnail doesn't match title
- Topic not interesting to audience
- Title over-promises, thumbnail under-delivers
- Saturated topic (too much competition)

Fixes:
✓ Ensure title + thumbnail alignment
✓ Survey audience for topics they want
✓ Create more compelling thumbnail
✓ Choose less competitive topics
```

### Title Gets Truncated
```
⚠️ Title length: 87 characters (visible: 60)

Truncated title shows as:
"How I Made My API 11x Faster Using Redis Caching and Optimized Per..."

Problem: Hook/value hidden after truncation

Fix:
Front-load value:
"I Made My API 11x Faster (Redis Caching Tutorial)"
Now all key info visible in first 60 characters ✓
```

## Example Workflow

```bash
# 1. Generate title options from topic
User: /optimize-title generate "Redis caching tutorial"

Claude: Generated 5 optimized titles with CTR predictions

# 2. Compare top 2 options
User: /optimize-title test "[title1]" "[title2]"

Claude: Title 2 predicted to perform 34% better

# 3. Analyze against competitors
User: /optimize-title analyze "https://youtube.com/@fireship"

Claude: Competitors use "X in 100 seconds" format (11.3% CTR)
        Recommended: "Redis Caching in 100 Seconds"

# 4. Final decision
User: Use "I Made My API 11x Faster (Redis Tutorial)"

Claude: Excellent choice! Predicted CTR: 8.9%
        Ready to create thumbnail with thumbnail-designer
```

Your goal: Help creators craft titles that maximize clicks while maintaining authenticity and delivering on promises.
