# Cursor Skill Pack

> Flagship+ tier: 30 comprehensive skills for Cursor IDE mastery

## Overview

Complete Claude Code skill pack for [Cursor](https://cursor.com) - the AI-first code editor. Covers AI code completion, composer workflows, codebase indexing, rules configuration, and production optimization.

## Installation

```bash
# Via Claude Code
/plugin install cursor-pack@claude-code-plugins-plus

# Via npm
npm install @intentsolutionsio/cursor-skill-md-pack
```

## Skills Included (30)

### Onboarding & Foundations (6 skills)
- **cursor-install-auth** - Installation and authentication setup
- **cursor-hello-world** - First project with AI features
- **cursor-local-dev-loop** - Local development workflow
- **cursor-keybindings** - Keyboard shortcuts and commands
- **cursor-ai-chat** - AI chat interface mastery
- **cursor-tab-completion** - Tab completion and suggestions

### Operations & Debugging (6 skills)
- **cursor-common-errors** - Common issues and fixes
- **cursor-debug-bundle** - Debugging AI suggestions
- **cursor-indexing-issues** - Codebase indexing troubleshooting
- **cursor-model-selection** - AI model configuration
- **cursor-prod-checklist** - Production readiness checklist
- **cursor-upgrade-migration** - Version upgrades and migrations

### CI/CD & Deployment (6 skills)
- **cursor-composer-workflows** - Composer for multi-file edits
- **cursor-rules-config** - .cursorrules configuration
- **cursor-context-management** - Context window optimization
- **cursor-codebase-indexing** - Codebase indexing setup
- **cursor-git-integration** - Git workflow integration
- **cursor-reference-architecture** - Reference architecture patterns

### Enterprise & Compliance (6 skills)
- **cursor-team-setup** - Team and organization setup
- **cursor-privacy-settings** - Privacy and data handling
- **cursor-api-key-management** - API key configuration
- **cursor-sso-integration** - SSO and enterprise auth
- **cursor-usage-analytics** - Usage tracking and analytics
- **cursor-compliance-audit** - Compliance and audit trails

### Advanced Patterns (6 skills)
- **cursor-advanced-composer** - Advanced composer techniques
- **cursor-custom-prompts** - Custom prompt engineering
- **cursor-multi-repo** - Multi-repository workflows
- **cursor-extension-integration** - VS Code extension compatibility
- **cursor-performance-tuning** - Performance optimization
- **cursor-known-pitfalls** - Common pitfalls and solutions

## Quick Start

After installation, these skills activate automatically when you:
- Ask about Cursor setup or configuration
- Need help with AI code completion
- Want to optimize composer workflows
- Configure .cursorrules files
- Troubleshoot indexing issues

## Links

- [Cursor Documentation](https://docs.cursor.com)
- [Cursor Dashboard](https://cursor.com/settings)
- [Plugin Marketplace](https://claudecodeplugins.io)

## License

MIT
