# Best Practices

## Best Practices

### Chat Session Management
```
1. One topic per chat session
2. Clear context between major changes
3. Summarize decisions before long gaps
4. Export important decisions to docs
```

### @-mention Strategy
```
Essential: Files you're directly modifying
Helpful: Files with patterns to follow
Wasteful: Entire folders "for context"

Start minimal, add if AI needs more
```

### Code Selection
```
Select precisely:
- The function with the issue
- The type definition needed
- The specific error location

Not:
- Entire files
- Multiple unrelated functions
- Large code blocks "just in case"
```