# Essential Extensions

## Essential Extensions

### Code Quality
```
ESLint (dbaeumer.vscode-eslint)
- Integrates ESLint into Cursor
- Real-time linting
- Auto-fix on save

Prettier (esbenp.prettier-vscode)
- Code formatting
- Consistent style
- Format on save

SonarLint (sonarsource.sonarlint-vscode)
- Security issues
- Code smells
- Best practices
```

### Language Support
```
TypeScript:
- Built-in (no extension needed)

Python:
- Python (ms-python.python)
- Pylance (ms-python.vscode-pylance)

Go:
- Go (golang.go)

Rust:
- rust-analyzer (rust-lang.rust-analyzer)

Java:
- Language Support (redhat.java)
```

### Framework Extensions
```
React/Next.js:
- ES7+ Snippets (dsznajder.es7-react-js-snippets)
- Auto Import (steoates.autoimport)

Tailwind CSS:
- Tailwind IntelliSense (bradlc.vscode-tailwindcss)

Prisma:
- Prisma (prisma.prisma)

Docker:
- Docker (ms-azuretools.vscode-docker)
```

### Git Extensions
```
GitLens (eamodio.gitlens)
- Inline blame
- File history
- Compare branches
- Commit details

Git Graph (mhutchie.git-graph)
- Visual branch graph
- Easy checkout/merge
```