---
name: "cursor-hello-world"
description: |
  Create your first project with Cursor AI features. Triggers on "cursor hello world",
  "first cursor project", "cursor getting started", "try cursor ai", "cursor basics". Use when working with cursor hello world functionality. Trigger with phrases like "cursor hello world", "cursor world", "cursor".
allowed-tools: "Read, Write, Edit, Bash(cmd:*)"
version: 1.0.0
license: MIT
author: "Jeremy Longshore <jeremy@intentsolutions.io>"
---

# Cursor Hello World

## Overview

This skill helps you create your first project with Cursor AI features. It provides a quick 5-minute getting started guide covering tab completion, AI chat, and Composer to help you understand and use Cursor's core AI capabilities.

## Prerequisites

- Cursor IDE installed (from cursor.com)
- Account created and authenticated
- Basic programming knowledge
- Project folder ready

## Instructions

1. Create new project folder and open in Cursor
2. Create a new file and start typing code
3. Accept AI suggestions with Tab key
4. Try AI Chat (Cmd+L) with a question
5. Try Composer (Cmd+I) for multi-file generation
6. Explore inline edit (Cmd+K) for quick fixes

## Output

- Working Cursor installation
- First AI-generated code
- Understanding of core features
- Foundation for advanced usage

## Error Handling

See `{baseDir}/references/errors.md` for comprehensive error handling.

## Examples

See `{baseDir}/references/examples.md` for detailed examples.

## Resources

- [Cursor Getting Started](https://cursor.com/docs/getting-started)
- [Cursor Tutorial Videos](https://cursor.com/learn)
- [Cursor Discord Community](https://discord.gg/cursor)
