# Workflow Pitfalls

## Workflow Pitfalls

### Not Using Chat History
```
PITFALL:
Re-asking questions you've already asked.
Wasting time and tokens.

SOLUTION:
- Scroll up in chat history
- Reference previous responses
- Save useful responses
- Build knowledge base
```

### Ignoring Composer Review
```
PITFALL:
Clicking "Apply All" without review.
Unwanted changes across files.

SOLUTION:
- Review each file change
- Check for unintended modifications
- Apply selectively
- Use version control for safety
```

### Single-Tool Mindset
```
PITFALL:
Using only chat or only completions.
Missing efficiency gains from tool combinations.

SOLUTION:
- Completions for flow coding
- Chat for questions and review
- Composer for multi-file changes
- Inline edit for quick fixes
```