# Best Practices

## Best Practices

### Guide the AI
```python
# Be explicit about what you want
# TODO: implement binary search on sorted array
def binary_search(arr, target):
    │ ← Better completion with clear intent
```

### Use Type Hints
```python
def process(data: pd.DataFrame) -> pd.DataFrame:
    │ ← AI knows pandas methods to suggest
```

### Maintain Code Style
```javascript
// If your codebase uses certain patterns,
// AI learns and continues them
const Component = ({ props }) => {
  │ ← Matches your existing component patterns
};
```

### Review Before Accepting
```
Always review ghost text:
- Check logic correctness
- Verify variable names
- Ensure style consistency
- Watch for security issues
```