# Customer.io Skill Pack

> Claude Code skill pack for Customer.io integration (24 skills)

Customer.io is a marketing automation platform for email, push, SMS, and in-app messaging.

## Installation

```bash
/plugin install customerio-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `customerio-install-auth` | Install and configure Customer.io SDK/CLI authentication |
| `customerio-hello-world` | Create a minimal working Customer.io example |
| `customerio-local-dev-loop` | Configure Customer.io local development workflow |
| `customerio-sdk-patterns` | Apply production-ready Customer.io SDK patterns |
| `customerio-primary-workflow` | Execute Customer.io primary messaging workflow |
| `customerio-core-feature` | Implement Customer.io core feature integration |
| `customerio-common-errors` | Diagnose and fix Customer.io common errors |
| `customerio-debug-bundle` | Collect Customer.io debug evidence for support |
| `customerio-rate-limits` | Implement Customer.io rate limiting and backoff |
| `customerio-security-basics` | Apply Customer.io security best practices |
| `customerio-prod-checklist` | Execute Customer.io production deployment checklist |
| `customerio-upgrade-migration` | Plan and execute Customer.io SDK upgrades |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `customerio-ci-integration` | Configure Customer.io CI/CD integration |
| `customerio-deploy-pipeline` | Deploy Customer.io integrations to production |
| `customerio-webhooks-events` | Implement Customer.io webhook handling |
| `customerio-performance-tuning` | Optimize Customer.io API performance |
| `customerio-cost-tuning` | Optimize Customer.io costs and usage |
| `customerio-reference-architecture` | Implement Customer.io reference architecture |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `customerio-multi-env-setup` | Configure Customer.io multi-environment setup |
| `customerio-observability` | Set up Customer.io monitoring and observability |
| `customerio-advanced-troubleshooting` | Apply Customer.io advanced debugging techniques |
| `customerio-reliability-patterns` | Implement Customer.io reliability patterns |
| `customerio-load-scale` | Implement Customer.io load testing and scaling |
| `customerio-known-pitfalls` | Identify and avoid Customer.io anti-patterns |

## Usage

Skills trigger automatically when you discuss Customer.io topics. For example:

- "Help me set up Customer.io" -> triggers `customerio-install-auth`
- "Debug this Customer.io error" -> triggers `customerio-common-errors`
- "Deploy my Customer.io integration" -> triggers `customerio-deploy-pipeline`
- "Set up Customer.io webhooks" -> triggers `customerio-webhooks-events`

## License

MIT
