---
name: monitor-errors
description: Monitor and analyze error rates
---
# Error Rate Monitor

Set up comprehensive error rate monitoring and alerting.

## Monitoring Areas

1. **HTTP Errors**: 4xx and 5xx response tracking
2. **Application Exceptions**: Unhandled exception monitoring
3. **Database Errors**: Query failures and timeouts
4. **External API Errors**: Third-party service failures
5. **Background Job Errors**: Async task failures
6. **Client-Side Errors**: Frontend error tracking

## Process

1. Analyze application architecture and error sources
2. Identify critical error scenarios
3. Design error tracking strategy
4. Create monitoring configuration
5. Define alert thresholds and escalation
6. Generate implementation guide

## Output

Provide:
- Error monitoring setup (Sentry, Rollbar, CloudWatch, etc.)
- Error categorization and tagging strategy
- Alert rule definitions with thresholds
- Dashboard configuration for error tracking
- Error budget calculations
- Incident response guidelines
