# LangChain Skill Pack

> Claude Code skill pack for LangChain integration (24 skills)

## Installation

```bash
/plugin install langchain-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `langchain-install-auth` | Install and configure LangChain SDK |
| `langchain-hello-world` | Create minimal LangChain example |
| `langchain-local-dev-loop` | Local development workflow |
| `langchain-sdk-patterns` | Production-ready SDK patterns |
| `langchain-core-workflow-a` | Chains and prompts workflow |
| `langchain-core-workflow-b` | Agents and tools workflow |
| `langchain-common-errors` | Diagnose common errors |
| `langchain-debug-bundle` | Collect debug evidence |
| `langchain-rate-limits` | Rate limiting and backoff |
| `langchain-security-basics` | Security best practices |
| `langchain-prod-checklist` | Production checklist |
| `langchain-upgrade-migration` | SDK upgrade guide |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `langchain-ci-integration` | CI/CD pipeline integration |
| `langchain-deploy-integration` | Production deployment |
| `langchain-webhooks-events` | Callback and event handling |
| `langchain-performance-tuning` | Performance optimization |
| `langchain-cost-tuning` | Token and cost optimization |
| `langchain-reference-architecture` | Reference architecture patterns |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `langchain-multi-env-setup` | Multi-environment configuration |
| `langchain-observability` | Monitoring and observability |
| `langchain-incident-runbook` | Incident response procedures |
| `langchain-data-handling` | Data privacy and handling |
| `langchain-enterprise-rbac` | Enterprise access control |
| `langchain-migration-deep-dive` | Complex migration strategies |

## Usage

Skills trigger automatically when you discuss LangChain topics. For example:

- "Help me set up LangChain" -> triggers `langchain-install-auth`
- "Debug this LangChain error" -> triggers `langchain-common-errors`
- "Deploy my LangChain integration" -> triggers `langchain-deploy-integration`
- "Create a LangChain agent" -> triggers `langchain-core-workflow-b`

## License

MIT
