# Liquidity Pool Analyzer Plugin

Analyze DeFi liquidity pools for APY, impermanent loss, and optimization opportunities across multiple protocols.

## Features

- **Impermanent Loss Calculator**: Real-time IL tracking and projections
- **APY Analysis**: Base fees, rewards, and total returns
- **Risk Assessment**: Volatility, liquidity depth, protocol risks
- **Optimization**: Range optimization for concentrated liquidity
- **Multi-Protocol**: Uniswap V3, Curve, Balancer, PancakeSwap

## Installation

```bash
/plugin install liquidity-pool-analyzer@claude-code-plugins-plus
```

## Commands

| Command | Description | Shortcut |
|---------|-------------|----------|
| `/analyze-pool` | Analyze liquidity pool | `ap` |
| `/compare-pools` | Compare multiple pools | `cp` |
| `/il-calculator` | Calculate impermanent loss | `il` |

---

*Built for liquidity providers by Intent Solutions IO*