---
name: optimize
description: Get performance optimization recommendations
---
# Performance Optimization Advisor

Receive comprehensive, prioritized performance optimization recommendations.

## Optimization Areas

1. **Frontend Optimization**
   - Bundle size reduction
   - Code splitting
   - Lazy loading
   - Image optimization
   - Caching strategies

2. **Backend Optimization**
   - Database query optimization
   - API response time improvement
   - Caching layers
   - Connection pooling
   - Async processing

3. **Infrastructure Optimization**
   - CDN implementation
   - Load balancing
   - Auto-scaling configuration
   - Resource right-sizing

4. **Architecture Optimization**
   - Service decomposition
   - Event-driven patterns
   - Read replicas
   - Queue-based processing

## Process

1. Analyze current application architecture
2. Review code for performance anti-patterns
3. Evaluate infrastructure setup
4. Identify quick wins and long-term improvements
5. Prioritize recommendations by impact and effort
6. Generate implementation roadmap

## Output

Provide comprehensive report with:
- Executive summary of performance state
- Categorized optimization opportunities
- Prioritization matrix (impact vs effort)
- Detailed recommendations with:
  - Current state analysis
  - Proposed improvement
  - Implementation steps
  - Expected performance gains
  - Code examples
- Quick wins (low effort, high impact)
- Long-term architectural improvements
- Implementation roadmap with phases
