---
name: track-resources
description: Track resource usage and optimize allocation
---
# Resource Usage Tracker

Implement comprehensive resource usage tracking and optimization.

## Resources to Track

1. **CPU Usage**: Process and thread-level CPU consumption
2. **Memory Usage**: Heap, stack, and RSS memory
3. **Disk I/O**: Read/write operations and throughput
4. **Network I/O**: Bandwidth and connection usage
5. **File Descriptors**: Open file and socket counts
6. **Database Connections**: Connection pool utilization
7. **Thread/Process Counts**: Concurrency resource usage

## Process

1. Identify all resource consumption points
2. Design monitoring instrumentation strategy
3. Implement resource tracking
4. Create dashboards and alerts
5. Generate optimization recommendations

## Output

Provide:
- Resource monitoring instrumentation code
- Dashboard configuration for resource metrics
- Alert thresholds for resource exhaustion
- Resource optimization strategies
- Right-sizing recommendations
- Cost optimization opportunities
