# Error Handling Reference

**Common Issues and Resolutions**:

1. **Domain Unreachable**
   - Error: "Failed to connect to example.com"
   - Resolution: Check domain spelling, network connectivity, firewall rules
   - Fallback: Test alternate protocols (HTTP vs HTTPS)

2. **SSL/TLS Errors**
   - Error: "SSL certificate verification failed"
   - Resolution: Note in report, test with certificate validation disabled
   - Impact: Indicates HSTS not properly enforced

3. **Redirect Loops**
   - Error: "Too many redirects"
   - Resolution: Report redirect chain, analyze headers at each hop
   - Note: Headers may differ across redirect chain

4. **Rate Limiting**
   - Error: "HTTP 429 Too Many Requests"
   - Resolution: Implement exponential backoff, reduce request frequency
   - Fallback: Queue domain for later analysis

5. **Mixed Content Issues**
   - Error: "Headers differ between HTTP and HTTPS"
   - Resolution: Report both sets, highlight critical differences
   - Recommendation: Ensure HSTS enforces HTTPS-only