---
name: analyzing-text-sentiment
description: |
  Execute this skill enables AI assistant to analyze the sentiment of text data. it identifies the emotional tone expressed in text, classifying it as positive, negative, or neutral. use this skill when a user requests sentiment analysis, opinion mining, or emoti... Use when analyzing code or data. Trigger with phrases like 'analyze', 'review', or 'examine'.
allowed-tools: Read, Write, Bash(cmd:*), Grep
version: 1.0.0
author: Jeremy Longshore <jeremy@intentsolutions.io>
license: MIT
---
# Sentiment Analysis Tool

This skill provides automated assistance for sentiment analysis tool tasks.

## Overview

This skill empowers Claude to perform sentiment analysis on text, providing insights into the emotional content and polarity of the provided data. By leveraging AI/ML techniques, it helps understand public opinion, customer feedback, and overall emotional tone in written communication.

## How It Works

1. **Text Input**: The skill receives text data as input from the user.
2. **Sentiment Analysis**: The skill processes the text using a pre-trained sentiment analysis model to determine the sentiment polarity (positive, negative, or neutral).
3. **Result Output**: The skill provides a sentiment score and classification, indicating the overall sentiment expressed in the text.

## When to Use This Skill

This skill activates when you need to:
- Determine the overall sentiment of customer reviews.
- Analyze the emotional tone of social media posts.
- Gauge public opinion on a particular topic.
- Identify positive and negative feedback in survey responses.

## Examples

### Example 1: Analyzing Customer Reviews

User request: "Analyze the sentiment of these customer reviews: 'The product is amazing!', 'The service was terrible.', 'It was okay.'"

The skill will:
1. Process the provided customer reviews.
2. Classify each review as positive, negative, or neutral and provide sentiment scores.

### Example 2: Monitoring Social Media Sentiment

User request: "Perform sentiment analysis on the following tweet: 'I love this new feature!'"

The skill will:
1. Analyze the provided tweet.
2. Identify the sentiment as positive and provide a corresponding sentiment score.

## Best Practices

- **Data Quality**: Ensure the input text is clear and free from ambiguous language for accurate sentiment analysis.
- **Context Awareness**: Consider the context of the text when interpreting sentiment scores, as sarcasm or irony can affect results.
- **Model Selection**: Use appropriate sentiment analysis models based on the type of text being analyzed (e.g., social media, customer reviews).

## Integration

This skill can be integrated with other Claude Code plugins to automate workflows, such as summarizing feedback alongside sentiment scores or triggering actions based on sentiment polarity (e.g., escalating negative feedback).

## Prerequisites

- Appropriate file access permissions
- Required dependencies installed

## Instructions

1. Invoke this skill when the trigger conditions are met
2. Provide necessary context and parameters
3. Review the generated output
4. Apply modifications as needed

## Output

The skill produces structured output relevant to the task.

## Error Handling

- Invalid input: Prompts for correction
- Missing dependencies: Lists required components
- Permission errors: Suggests remediation steps

## Resources

- Project documentation
- Related skills and commands