# Sentry Skill Pack

Complete Sentry integration with 30 skills for Claude Code covering error tracking, performance monitoring, release management, and production operations.

## Installation

```bash
# Claude Code
/plugin install sentry-pack@claude-code-plugins-plus

# npm
npm install @intentsolutionsio/sentry-pack
```

## Skills Overview (30 Total)

### Onboarding & Foundations (6 skills)
- `sentry-install-auth` - Install SDK and configure authentication
- `sentry-hello-world` - First error capture and verification
- `sentry-local-dev-loop` - Local development workflow
- `sentry-sdk-patterns` - TypeScript/Python SDK best practices
- `sentry-error-capture` - Error capture and context enrichment
- `sentry-performance-tracing` - Performance monitoring setup

### Operations & Debugging (6 skills)
- `sentry-common-errors` - Common integration issues and fixes
- `sentry-debug-bundle` - Debug information collection
- `sentry-rate-limits` - Rate limiting and quota management
- `sentry-security-basics` - Security configuration
- `sentry-prod-checklist` - Production deployment checklist
- `sentry-upgrade-migration` - Version upgrades and migrations

### CI/CD & Deployment (6 skills)
- `sentry-ci-integration` - GitHub Actions and CI setup
- `sentry-deploy-integration` - Deployment tracking
- `sentry-release-management` - Release and commit tracking
- `sentry-performance-tuning` - Performance optimization
- `sentry-cost-tuning` - Cost optimization strategies
- `sentry-reference-architecture` - Best-practice architecture

### Enterprise & Compliance (6 skills)
- `sentry-multi-env-setup` - Multi-environment configuration
- `sentry-observability` - Full observability stack
- `sentry-incident-runbook` - Incident response procedures
- `sentry-data-handling` - PII and data scrubbing
- `sentry-enterprise-rbac` - Team and permission management
- `sentry-migration-deep-dive` - Complex migration scenarios

### Advanced Patterns (6 skills)
- `sentry-advanced-troubleshooting` - Complex debugging
- `sentry-load-scale` - High-volume event handling
- `sentry-reliability-patterns` - Reliability and resilience
- `sentry-policy-guardrails` - Policy enforcement
- `sentry-architecture-variants` - Architecture patterns
- `sentry-known-pitfalls` - Common pitfalls and solutions

## Tier

**Flagship+** - Complete coverage with 30 skills

## Resources

- [Sentry Documentation](https://docs.sentry.io)
- [Sentry Dashboard](https://sentry.io)
- [Sentry Status](https://status.sentry.io)

## License

MIT
