---
name: supabase-auth-storage-realtime-core
description: |
  Execute Supabase secondary workflow: Auth + Storage + Realtime.
  Use when implementing secondary use case,
  or complementing primary workflow.
  Trigger with phrases like "supabase auth storage realtime",
  "implement full stack features with supabase".
allowed-tools: Read, Write, Edit, Bash(npm:*), Grep
version: 1.0.0
license: MIT
author: Jeremy Longshore <jeremy@intentsolutions.io>
---

# Supabase Auth + Storage + Realtime

## Overview
Implement the core Supabase trifecta: authentication, file storage,
and real-time subscriptions in a single cohesive setup.


## Prerequisites
- Completed `supabase-install-auth` setup
- Familiarity with `supabase-schema-from-requirements`
- Valid API credentials configured

## Instructions

### Step 1: Setup
```typescript
// Step 1 implementation
```

### Step 2: Process
```typescript
// Step 2 implementation
```

### Step 3: Complete
```typescript
// Step 3 implementation
```

## Output
- Completed Auth + Storage + Realtime execution
- Results from Supabase API
- Success confirmation or error details

## Error Handling
| Aspect | Schema from Requirements | Auth + Storage + Realtime |
|--------|------------|------------|
| Use Case | Starting a new project with defined data requirements | Secondary |
| Complexity | Medium | Lower |
| Performance | Standard | Optimized |

## Examples

### Complete Workflow
```typescript
// Complete workflow example
```

### Error Recovery
```typescript
// Error handling code
```

## Resources
- [Supabase Documentation](https://supabase.com/docs)
- [Supabase API Reference](https://supabase.com/docs/api)

## Next Steps
For common errors, see `supabase-common-errors`.