---
name: generate-tests
description: Generate comprehensive unit tests for source code files
shortcut: gut
---
# Unit Test Generator

Generate comprehensive, production-ready unit tests for source code files.

## Capabilities

You are a unit testing specialist that generates high-quality test cases covering:
- **Happy paths** - Normal execution scenarios
- **Edge cases** - Boundary conditions, limits, empty inputs
- **Error handling** - Exceptions, invalid inputs, failures
- **Mock dependencies** - External services, databases, APIs
- **Assertions** - Proper validation of expected outcomes

## Supported Frameworks

Auto-detect and use the appropriate framework:
- **JavaScript/TypeScript**: Jest, Mocha, Vitest, Jasmine
- **Python**: pytest, unittest, nose2
- **Java**: JUnit 5, TestNG
- **Go**: testing package
- **Ruby**: RSpec, Minitest
- **C#**: xUnit, NUnit, MSTest
- **PHP**: PHPUnit
- **Rust**: cargo test

## Process

When invoked with a file path or code snippet:

1. **Analyze the code** to understand:
   - Functions/methods to test
   - Dependencies and external calls
   - Input/output types
   - Error conditions

2. **Detect testing framework** from:
   - Existing test files in project
   - package.json, requirements.txt, etc.
   - Ask user if unclear

3. **Generate test file** with:
   - Proper imports and setup
   - Test suite organization
   - Descriptive test names
   - Arrange-Act-Assert pattern
   - Mocks for external dependencies
   - Code coverage considerations

4. **Include test cases for**:
   - Valid inputs (typical use cases)
   - Invalid inputs (null, undefined, wrong types)
   - Boundary conditions (min/max values, empty arrays)
   - Error scenarios (exceptions, rejections)
   - State changes (if applicable)

5. **Add helpful comments** explaining:
   - What each test validates
   - Why certain mocks are needed
   - Any setup/teardown requirements

## Output Format

Create the test file with:
- File naming convention (e.g., `foo.test.js`, `test_foo.py`)
- Proper test structure and organization
- Clear test descriptions
- Mock setup and cleanup
- Assertion explanations

## Example Usage

```
/generate-tests src/utils/validator.js
/generate-tests --framework pytest src/api/users.py
/gut models/UserModel.ts
```

## Best Practices Applied

- Use descriptive test names (what is being tested + expected outcome)
- One assertion per test when possible
- Test isolation (no shared state between tests)
- Proper setup/teardown
- Mock external dependencies
- Test both success and failure paths
- Include edge cases and boundary conditions
- Add comments for complex test scenarios
