# Vulnerability Scanner Plugin

Comprehensive vulnerability scanning for code, dependencies, and configurations with CVE detection and remediation guidance.

## Features

- **Static Application Security Testing (SAST)** - Scan source code for vulnerabilities
- **Dependency Scanning** - Check third-party packages for known CVEs
- **Configuration Analysis** - Review security-sensitive configurations
- **Severity Classification** - CVSS-based severity scoring
- **Remediation Guidance** - Actionable fix recommendations

## Installation

```bash
/plugin install vulnerability-scanner@claude-code-plugins-plus
```

## Usage

```bash
# Scan current directory
/scan

# Or use shortcut
/vuln
```

## What It Scans

### Code Vulnerabilities
- SQL injection risks
- Cross-site scripting (XSS)
- Command injection
- Path traversal
- Insecure deserialization
- Hardcoded credentials
- Weak cryptography
- Authentication bypasses

### Dependencies
- Known CVEs in npm packages
- Known CVEs in pip packages
- Known CVEs in composer packages
- Outdated packages with security patches
- Transitive dependency vulnerabilities

### Configuration Issues
- Insecure SSL/TLS settings
- Weak CORS policies
- Missing security headers
- Debug mode in production
- Exposed admin interfaces

## Report Output

The plugin generates a detailed vulnerability report with:

1. **Executive Summary**
   - Total vulnerabilities found
   - Breakdown by severity (Critical, High, Medium, Low)
   - Risk score

2. **Detailed Findings**
   - Vulnerability description
   - Affected files and line numbers
   - CVE identifiers (if applicable)
   - CVSS score
   - Code snippets
   - Remediation steps

3. **Recommendations**
   - Prioritized fix list
   - Security best practices
   - Links to security advisories

## Example Report

```
VULNERABILITY SCAN REPORT
=========================
Scan Date: 2025-10-11
Total Vulnerabilities: 12
  - Critical: 2
  - High: 5
  - Medium: 3
  - Low: 2

CRITICAL VULNERABILITIES
------------------------

1. SQL Injection in User Authentication
   File: src/auth/login.js:45
   Severity: Critical (CVSS 9.8)

   Vulnerable Code:
   const query = `SELECT * FROM users WHERE username='${username}'`

   Remediation:
   Use parameterized queries to prevent SQL injection:
   const query = 'SELECT * FROM users WHERE username = ?'
   db.query(query, [username])

2. Hardcoded API Key
   File: config/api.js:12
   Severity: Critical (CVSS 9.1)

   Vulnerable Code:
   const API_KEY = "sk-1234567890abcdef"

   Remediation:
   Move API key to environment variable:
   const API_KEY = process.env.API_KEY
```

## Security Best Practices

- Run scans regularly (pre-commit, pre-deploy)
- Address Critical and High severity issues immediately
- Keep dependencies updated
- Never commit vulnerability reports to public repositories
- Validate fixes with follow-up scans
- Document false positives for future reference

## Requirements

- Read access to codebase
- Access to package manifest files (package.json, requirements.txt, composer.json)
- Network access for CVE database lookups (optional)

## License

MIT License - See LICENSE file for details
