# 🔍 Web to GitHub Issue

> **Skill Enhancer Plugin**: Converts Claude's web research into actionable GitHub issues

[![Category](https://img.shields.io/badge/category-skill--enhancers-blueviolet)](https://claudecodeplugins.io)
[![Enhances](https://img.shields.io/badge/enhances-web__search-blue)](https://docs.anthropic.com/claude/docs/skills)
[![License](https://img.shields.io/badge/license-MIT-green)](LICENSE)

## ✨ What It Does

This plugin bridges the gap between research and action by automatically creating GitHub issues from Claude's web search results.

**The Flow:**
```
1. 🔍 Claude searches web (web_search Skill)
2. 📝 Plugin extracts key findings
3. 🎫 Creates formatted GitHub issue
4. ✅ Issue ready for team action
```

## 🎯 Use Cases

### Technical Research
Research best practices and create implementation tickets:
```bash
claude: "research PostgreSQL indexing best practices and create a ticket"
```

**Result:** GitHub issue with:
- Summary of indexing strategies
- Key recommendations with sources
- Related topics (performance, query optimization)
- Next steps checklist

### Security Monitoring
Stay on top of vulnerabilities:
```bash
claude: "find latest CVEs for React dependencies, create urgent security ticket"
```

**Result:** High-priority issue with:
- CVE details and severity
- Affected versions
- Remediation steps
- Source links to advisories

### Feature Research
Investigate competitor features:
```bash
claude: "research Stripe payment features, create feature request ticket"
```

**Result:** Feature request issue with:
- Feature comparison matrix
- Implementation considerations
- Market insights
- Next steps for evaluation

## 🚀 Installation

### Prerequisites
- Claude Code CLI
- GitHub Personal Access Token with `repo` scope
- Node.js 18+

### Install Plugin

```bash
# Add marketplace
/plugin marketplace add jeremylongshore/claude-code-plugins

# Install plugin
/plugin install web-to-github-issue@claude-code-plugins-plus
```

### Configure

```bash
# Set GitHub token
export GITHUB_TOKEN=ghp_your_token_here

# Optional: Set default repository
export GITHUB_DEFAULT_REPO=owner/repo
```

## 📖 Usage

### Natural Language

Just talk to Claude naturally:

```bash
claude: "research Docker security best practices and create a ticket in myorg/backend"
claude: "find articles about API rate limiting, create issue with label performance"
claude: "search for Kubernetes deployment patterns, create ticket and assign to alice"
```

### Command Syntax

```bash
# Basic usage
/research-and-ticket "topic"

# Specify repository
/research-and-ticket "topic" --repo owner/repo

# Add labels
/research-and-ticket "topic" --labels security,urgent

# Assign team members
/research-and-ticket "topic" --assignees user1,user2

# Shorthand alias
/rat "topic"
```

## 📊 Generated Issue Format

The plugin creates beautifully formatted GitHub issues:

### Example Issue

```markdown
# Research: PostgreSQL Indexing Best Practices

**Priority:** NORMAL

## Summary

Research compiled from 5 sources on 10/16/2025.

## Key Findings

- B-tree indexes should be used for most equality and range queries
  - Source: [PostgreSQL Documentation](https://postgresql.org/docs/indexes)

- Partial indexes can significantly reduce index size for filtered queries
  - Source: [Use The Index, Luke](https://use-the-index-luke.com)

- Index maintenance overhead increases with write-heavy workloads
  - Source: [Database Performance Blog](https://example.com/perf)

## Related Topics

`postgres` • `indexing` • `performance` • `query` • `optimization`

## Sources

### [PostgreSQL 15 Documentation - Indexes](https://postgresql.org/docs/15/indexes)

Complete guide to PostgreSQL indexing strategies including B-tree, Hash, GiST, and GIN indexes.

*Source: postgresql.org*

---

### [Use The Index, Luke - PostgreSQL](https://use-the-index-luke.com/postgresql)

In-depth tutorial on query performance and index optimization techniques.

*Source: use-the-index-luke.com*

---

## Next Steps

- [ ] Review findings
- [ ] Create implementation plan
- [ ] Assign to team member
- [ ] Set timeline

---

*Generated by [web-to-github-issue](https://claudecodeplugins.io) plugin*
*Research date: 10/16/2025, 5:30:00 PM*
```

## 🎨 Features

- **🔍 Automatic Research**: Leverages Claude's web_search Skill
- **📝 Smart Extraction**: Identifies key points and actionable items
- **🏷️ Intelligent Labeling**: Auto-detects priority from content
- **🔗 Source Preservation**: All URLs preserved for reference
- **⚡ Priority Detection**: Identifies urgent issues (CVEs, security)
- **✅ Action Checklists**: Adds next steps for actionable research

## 🔧 Configuration Options

### Environment Variables

| Variable | Required | Description |
|----------|----------|-------------|
| `GITHUB_TOKEN` | Yes | Personal Access Token with `repo` scope |
| `GITHUB_DEFAULT_REPO` | No | Default repository (owner/repo format) |

### Plugin Config

Create `.env` or add to shell profile:

```bash
# Required
export GITHUB_TOKEN=ghp_your_token_here

# Optional defaults
export GITHUB_DEFAULT_REPO=myorg/myrepo
export GITHUB_DEFAULT_LABELS=research,enhancement
```

## 🤔 How It Works

### 1. Research Phase
Claude uses the `web_search` Skill to find relevant information based on your query.

### 2. Analysis Phase
The plugin:
- Parses search results
- Extracts key findings
- Detects priority level (normal/urgent)
- Identifies if content is actionable
- Extracts related topics

### 3. Creation Phase
The plugin:
- Generates issue title
- Formats markdown body with sections
- Adds appropriate labels
- Creates GitHub issue via API
- Returns issue URL

### 4. Result
You get a fully formatted GitHub issue ready for team action, complete with:
- Research summary
- Key findings with sources
- Related topics
- Next steps
- All source links

## 🆚 Why Use This Plugin?

### Without Plugin
1. Ask Claude to research topic
2. Read through results
3. Manually open GitHub
4. Create new issue
5. Copy/paste findings
6. Format markdown
7. Add labels
8. Find and paste URLs

**Time: 10-15 minutes**

### With Plugin
1. Ask Claude to research and create ticket

**Time: 30 seconds**

**Time Saved: 95%**

## 🛠️ Requirements

- **Claude Code**: Latest version with Skills support
- **GitHub Token**: Personal Access Token with `repo` scope
  - [Create token](https://github.com/settings/tokens/new?scopes=repo&description=Claude%20Code%20Plugin)
- **Node.js**: Version 18 or higher
- **Repository Access**: Write access to target repositories

## 🐛 Troubleshooting

### Error: GitHub token required
```bash
# Set your token
export GITHUB_TOKEN=ghp_your_token_here

# Verify it's set
echo $GITHUB_TOKEN
```

### Error: Repository not found
```bash
# Check format
/research-and-ticket "topic" --repo owner/repo  # ✅ Correct
/research-and-ticket "topic" --repo repo        # ❌ Wrong

# Verify access
gh repo view owner/repo
```

### No search results found
- Try broader search terms
- Check internet connectivity
- Verify web_search Skill is available in your Claude Code instance

### Issue created but poorly formatted
- Plugin relies on quality search results
- Try more specific search terms
- Review and edit the generated issue as needed

## 📚 Related Plugins

- **web-to-slack-digest**: Research → Slack updates
- **web-to-docs**: Research → Documentation
- **research-and-deploy**: Research → Infrastructure deployment

## 🤝 Contributing

Contributions welcome! See [CONTRIBUTING.md](../../000-docs/007-DR-GUID-contributing.md)

## 📄 License

MIT License - see [LICENSE](LICENSE)

## 🔗 Links

- **Marketplace**: https://claudecodeplugins.io
- **Documentation**: https://claudecodeplugins.io/docs/web-to-github-issue
- **Issues**: https://github.com/jeremylongshore/claude-code-plugins/issues
- **Discussions**: https://github.com/jeremylongshore/claude-code-plugins/discussions

---

**Built with ❤️ for the Claude Code community**

*Part of the Skill Enhancers collection - plugins that extend Claude's Skills with automation*
