---
name: scanning-for-xss-vulnerabilities
description: |
  Execute this skill enables AI assistant to automatically scan for xss (cross-site scripting) vulnerabilities in code. it is triggered when the user requests to "scan for xss vulnerabilities", "check for xss", or uses the command "/xss". the skill identifies ref... Use when appropriate context detected. Trigger with relevant phrases based on skill purpose.
allowed-tools: Read, WebFetch, WebSearch, Grep
version: 1.0.0
author: Jeremy Longshore <jeremy@intentsolutions.io>
license: MIT
---
# Xss Vulnerability Scanner

This skill provides automated assistance for xss vulnerability scanner tasks.

## Overview

This skill empowers Claude to proactively identify and report XSS vulnerabilities within your codebase. By leveraging advanced detection techniques, including context-aware analysis and WAF bypass testing, this skill ensures your web applications are resilient against common XSS attack vectors. It provides detailed insights into vulnerability types and offers guidance on remediation strategies.

## How It Works

1. **Activation**: Claude recognizes the user's intent to scan for XSS vulnerabilities through specific trigger phrases like "scan for XSS" or the shortcut "/xss".
2. **Code Analysis**: The plugin analyzes the codebase, identifying potential XSS vulnerabilities across different contexts (HTML, JavaScript, CSS, URL).
3. **Vulnerability Detection**: The plugin detects reflected, stored, and DOM-based XSS vulnerabilities by injecting various payloads and analyzing the responses.
4. **Reporting**: The plugin generates a report highlighting identified vulnerabilities, their location in the code, and recommended remediation steps.

## When to Use This Skill

This skill activates when you need to:
- Perform a security audit of your web application.
- Review code for potential XSS vulnerabilities.
- Ensure compliance with security standards.
- Test the effectiveness of your Content Security Policy (CSP).
- Identify and mitigate XSS vulnerabilities before deploying to production.

## Examples

### Example 1: Detecting Reflected XSS

User request: "scan for XSS vulnerabilities in the search functionality"

The skill will:
1. Analyze the code related to the search functionality.
2. Identify a reflected XSS vulnerability in how search queries are displayed.
3. Report the vulnerability, including the affected code snippet and a suggested fix using proper sanitization.

### Example 2: Identifying Stored XSS

User request: "/xss check the comment submission form"

The skill will:
1. Analyze the comment submission form and its associated backend code.
2. Detect a stored XSS vulnerability where user comments are saved to the database without sanitization.
3. Report the vulnerability, highlighting the unsanitized comment storage and suggesting the use of a sanitization library like `sanitizeHtml`.

## Best Practices

- **Sanitization**: Always sanitize user input before displaying it on the page. Use appropriate escaping functions for the specific context (HTML, JavaScript, URL).
- **Content Security Policy (CSP)**: Implement a strong CSP to restrict the sources from which the browser can load resources, mitigating the impact of XSS vulnerabilities.
- **Regular Updates**: Keep your web application framework and libraries up to date to patch known XSS vulnerabilities.

## Integration

This skill complements other security-focused plugins by providing targeted XSS vulnerability detection. It can be integrated with code review tools to automate security checks and provide developers with immediate feedback on potential XSS issues.

## Prerequisites

- Appropriate file access permissions
- Required dependencies installed

## Instructions

1. Invoke this skill when the trigger conditions are met
2. Provide necessary context and parameters
3. Review the generated output
4. Apply modifications as needed

## Output

The skill produces structured output relevant to the task.

## Error Handling

- Invalid input: Prompts for correction
- Missing dependencies: Lists required components
- Permission errors: Suggests remediation steps

## Resources

- Project documentation
- Related skills and commands