# Best Practices

## Best Practices

### Source Priority (Use This When Conflicts Exist)

**Trust Priority Order:**
1. **Website** - Public-facing, most authoritative
2. **GitHub** - Developer-facing, technical accuracy
3. **Local Docs** - Internal-use, lowest priority for public messaging

**Update Flow:**
Website → GitHub → Local Docs

### When to Run Validation

✅ **Run validation BEFORE:**
- Updating internal documentation
- Creating training materials
- Writing new marketing content
- Publishing blog posts
- Releasing new versions

✅ **Run validation AFTER:**
- Website updates
- GitHub README changes
- Major feature releases
- Rebranding efforts

### What This Skill Does NOT Do

❌ Does NOT automatically fix issues
❌ Does NOT modify any files
❌ Does NOT make content decisions
❌ Does NOT prioritize which version is "correct"
✅ ONLY generates read-only reports for human review