---
name: analyze-capacity
description: Analyze capacity and plan for growth
---
# Capacity Planning Analyzer

Analyze current capacity and plan for future growth requirements.

## Analysis Areas

1. **Current Utilization**: Resource usage patterns
2. **Growth Trends**: Traffic and data growth rates
3. **Peak Capacity**: Maximum load handling
4. **Scaling Thresholds**: When to scale up/out
5. **Cost Projections**: Budget requirements for growth

## Capacity Metrics

- CPU and memory utilization trends
- Database storage growth
- Network bandwidth usage
- Request rate growth
- Connection pool saturation

## Process

1. Analyze current resource utilization
2. Identify growth trends from historical data
3. Project future capacity needs
4. Evaluate scaling strategies (vertical vs horizontal)
5. Calculate cost implications
6. Generate capacity roadmap

## Output

Provide:
- Current capacity utilization report
- Growth trend analysis with visualizations
- Capacity forecast for 6-12 months
- Scaling recommendations (when and how)
- Cost projections for capacity expansion
- Monitoring setup to track capacity metrics
- Early warning thresholds for capacity constraints
