---
name: coderabbit-core-workflow-b
description: |
  Execute CodeRabbit secondary workflow: Core Workflow B.
  Use when implementing secondary use case,
  or complementing primary workflow.
  Trigger with phrases like "coderabbit secondary workflow",
  "secondary task with coderabbit".
allowed-tools: Read, Write, Edit, Bash(npm:*), Grep
version: 1.0.0
license: MIT
author: Jeremy Longshore <jeremy@intentsolutions.io>
---

# CodeRabbit Core Workflow B

## Overview
Secondary workflow for CodeRabbit. Complements the primary workflow.

## Prerequisites
- Completed `coderabbit-install-auth` setup
- Familiarity with `coderabbit-core-workflow-a`
- Valid API credentials configured

## Instructions

### Step 1: Setup
```typescript
// Step 1 implementation
```

### Step 2: Process
```typescript
// Step 2 implementation
```

### Step 3: Complete
```typescript
// Step 3 implementation
```

## Output
- Completed Core Workflow B execution
- Results from CodeRabbit API
- Success confirmation or error details

## Error Handling
| Aspect | Workflow A | Workflow B |
|--------|------------|------------|
| Use Case | Primary | Secondary |
| Complexity | Medium | Lower |
| Performance | Standard | Optimized |

## Examples

### Complete Workflow
```typescript
// Complete workflow example
```

### Error Recovery
```typescript
// Error handling code
```

## Resources
- [CodeRabbit Documentation](https://docs.coderabbit.com)
- [CodeRabbit API Reference](https://docs.coderabbit.com/api)

## Next Steps
For common errors, see `coderabbit-common-errors`.