---
name: repurpose
description: Transform one long-form video into 30+ pieces of content across all...
---
# Repurpose Content Command

Transform one video into 30+ optimized content pieces across platforms, maximizing reach and minimizing effort.

## Usage

```bash
/repurpose [video-url]                       # Generate all content from video
/repurpose [video] --platforms youtube,tiktok,twitter  # Specific platforms
/repurpose analyze [video]                   # Show repurposing opportunities
/repurpose batch [video-list]                # Process multiple videos
```

## Purpose

Maximize content ROI by:
- **1 video → 30+ pieces** - Amplify reach exponentially
- **Platform-specific optimization** - Adapt for each audience
- **Zero additional recording** - Reuse existing content
- **SEO multiplication** - Rank for more keywords
- **Consistent multi-platform presence** - Be everywhere

## Repurposing Strategy

When user runs `/repurpose "I Made My API 11x Faster"`:

```
♻️ CONTENT REPURPOSING PLAN

Source: "I Made My API 11x Faster (Redis Tutorial)"
Length: 10:12 minutes
Content created: 34 pieces

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📹 VIDEO DERIVATIVES (8 pieces)

1. YouTube Full Video (Primary)
   ├─ Format: Original 10:12 video
   ├─ Platform: YouTube
   └─ Status: Published ✓

2. YouTube Shorts (3 clips)
   ├─ Clip 1: "The Problem" (0:15-2:00) → 45 seconds
   ├─ Clip 2: "The Solution" (4:30-5:45) → 60 seconds
   ├─ Clip 3: "The Results" (8:00-9:15) → 60 seconds
   └─ Post: Daily over 3 days

3. TikTok Videos (2 versions)
   ├─ Version A: High-energy highlight reel (60 sec)
   ├─ Version B: Educational breakdown (60 sec)
   └─ Post: Tuesday and Friday

4. Instagram Reels (2 versions)
   ├─ Version A: Same as TikTok A
   ├─ Version B: Behind-the-scenes style
   └─ Post: Tuesday and Thursday

5. LinkedIn Native Video
   ├─ Format: 2-minute professional edit
   ├─ Focus: Business impact angle
   └─ Post: Tuesday 9 AM

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📝 TEXT CONTENT (12 pieces)

6. Blog Post (Full Tutorial)
   ├─ 2,000-word article with code examples
   ├─ Video embedded at top
   ├─ SEO optimized for "make api faster"
   └─ Expected: 5K-20K pageviews over 12 months

7. Twitter Thread (Main)
   ├─ 10 tweets breaking down the optimization
   ├─ Code snippets + screenshots
   ├─ Links to YouTube and blog
   └─ Post: Wednesday 11 AM

8. Twitter Thread (Behind-the-Scenes)
   ├─ 8 tweets about the recording process
   ├─ Learnings and gotchas
   └─ Post: Friday 2 PM

9. LinkedIn Article
   ├─ Professional angle: "How We Improved API Performance by 1,100%"
   ├─ 800 words, business-focused
   └─ Publish: Thursday

10. Dev.to Post
    ├─ Technical deep dive
    ├─ Full code repository linked
    └─ Cross-post to Medium, Hashnode

11. Reddit Posts (3 communities)
    ├─ r/webdev: Tutorial post with code
    ├─ r/node: Node.js-specific discussion
    ├─ r/programming: General interest angle
    └─ Post: Stagger over 1 week

12. Quora Answers (5 questions)
    ├─ "How can I make my API faster?"
    ├─ "What is Redis used for?"
    ├─ "Best practices for API optimization"
    ├─ "Redis vs database for caching"
    ├─ "How to improve API performance"
    └─ Each answer links to video

13. GitHub Gist
    ├─ Full code from video
    ├─ Comments and explanations
    └─ Links to video tutorial

14-17. Email Newsletter (4-part series)
    ├─ Part 1: Why your API is slow
    ├─ Part 2: Introduction to Redis
    ├─ Part 3: Implementation walkthrough
    ├─ Part 4: Production best practices
    └─ Send: Weekly over 4 weeks

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🖼️ VISUAL CONTENT (8 pieces)

18-20. Instagram Carousel Posts (3 posts)
    ├─ Post 1: "5 Steps to 10x API Performance"
    ├─ Post 2: "Redis Caching Explained (Visual)"
    ├─ Post 3: "Before vs After: API Performance"
    └─ Each post: 6-8 slides with graphics

21-23. Twitter Image Posts (3 posts)
    ├─ Post 1: Performance graph (before/after)
    ├─ Post 2: Code snippet with explanation
    ├─ Post 3: Key takeaways infographic
    └─ Post: Daily over 3 days

24. Pinterest Pin
    ├─ Infographic: "10x Your API Performance"
    ├─ Links to blog post
    └─ Evergreen SEO traffic

25. SlideShare Presentation
    ├─ 15-slide deck from video
    ├─ Professional format
    └─ Links to video and blog

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🎙️ AUDIO CONTENT (3 pieces)

26. Podcast Episode (Audio only)
    ├─ Extract audio from video
    ├─ Add intro/outro music
    ├─ Upload to podcast platforms
    └─ Spotify, Apple Podcasts, etc.

27. Audio Article (for commuters)
    ├─ Blog post read aloud
    ├─ Natural voice AI
    └─ Embed on blog

28. Voice Note/Thread (Twitter Spaces recap)
    ├─ Short 3-minute audio summary
    └─ Share on social media

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💬 COMMUNITY CONTENT (6 pieces)

29. YouTube Community Post
    ├─ "What's your slowest API endpoint?"
    ├─ Engagement poll or question
    └─ Promotes new video

30. Twitter Poll
    ├─ "What do you use for caching?"
    ├─ Options: Redis, Memcached, None, Other
    └─ Drives discussion

31. LinkedIn Poll
    ├─ "What's your API performance bottleneck?"
    ├─ Professional angle
    └─ Leads to video

32. Discord/Slack Message
    ├─ Share in relevant communities
    ├─ Add personal context
    └─ Invite discussion

33. Facebook Group Posts (3 groups)
    ├─ Web developer groups
    ├─ Personalized introduction per group
    └─ Follow community rules

34. Newsletter CTA
    ├─ Subscribe prompt at end of video
    ├─ Offer: "Get the full code + bonus tips"
    └─ Build email list

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 EXPECTED REACH

Total Pieces: 34
Estimated Total Reach: 300K-900K impressions
Time Investment:
├─ Original video creation: 6 hours
├─ Repurposing all content: 3 hours
└─ Total: 9 hours → 34 pieces = 16 minutes per piece

ROI: 1 video = 34 pieces = 10x content output

Platform Distribution:
├─ YouTube: 4 pieces (main video + shorts)
├─ TikTok: 2 pieces
├─ Instagram: 5 pieces (reels + carousels)
├─ Twitter: 8 pieces (threads, images, polls)
├─ LinkedIn: 3 pieces (video, article, poll)
├─ Blog/SEO: 5 pieces (blog, Dev.to, Medium, etc.)
├─ Reddit/Quora: 8 pieces
├─ Audio: 3 pieces
└─ Community: 6 pieces

Timeline:
├─ Week 1: Primary distribution (video, blog, social)
├─ Week 2: Secondary platforms (Reddit, Quora)
├─ Week 3: Evergreen content (Pinterest, SlideShare)
└─ Week 4: Email series begins

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

## Platform-Specific Adaptations

### YouTube Shorts (from long-form)
```
✂️ EXTRACTING SHORTS

Source: 10-minute video
Target: 3 YouTube Shorts (60 seconds each)

Short 1: "The Hook" (Problem reveal)
├─ Timestamp: 0:15-1:00 (45 seconds)
├─ Title: "Why Your API is Slow"
├─ Add: Captions, hook text overlay
├─ Format: Vertical crop of main video
└─ Post: Day 2 after main video

Short 2: "The Solution" (Aha moment)
├─ Timestamp: 4:30-5:30 (60 seconds)
├─ Title: "One Tool Made My API 10x Faster"
├─ Add: Dramatic reveal, music
├─ Format: Vertical, high-energy edit
└─ Post: Day 5 after main video

Short 3: "The Results" (Proof)
├─ Timestamp: 8:00-9:00 (60 seconds)
├─ Title: "2000ms to 180ms (Here's How)"
├─ Add: Before/after graphics
├─ Format: Vertical, text-heavy
└─ Post: Day 8 after main video

Editing: 15 minutes per short
Expected views: 10K-50K each
```

### Twitter Thread (from transcript)
```
🐦 TWITTER THREAD CREATION

Source: Video transcript + key points
Output: 10-tweet thread

Tweet 1 (Hook):
I just made my API 11x faster in 1 hour 🚀

2000ms → 180ms response time

The secret? Redis caching.

Here's the full breakdown: 🧵👇

[GIF of before/after metrics]

Tweet 2-9: Key steps, code snippets, gotchas
Tweet 10: CTA with links

Time to create: 20 minutes
Expected impressions: 10K-40K
```

### Blog Post (from video content)
```
📝 BLOG POST GENERATION

Source: Video content + transcript
Output: 2,000-word SEO article

Structure:
├─ Hero section: Video embed + stats
├─ Introduction: Problem and solution
├─ Background: API performance basics
├─ Implementation: Step-by-step with code
├─ Results: Before/after comparison
├─ Best practices: Production tips
├─ Conclusion: Summary + resources

SEO Optimization:
├─ Primary keyword: "make api faster"
├─ Meta description: Optimized
├─ Internal links: 5-7 related posts
├─ Images: Screenshots with alt text
├─ Schema markup: Article/HowTo
└─ Table of contents

Time to create: 45 minutes (with AI assistance)
Expected pageviews: 5K-20K (12 months)
```

## Automation Workflow

```
🤖 REPURPOSING AUTOMATION

Step 1: Video Analysis
├─ Extract transcript
├─ Identify key moments
├─ Generate timestamps
└─ Extract quotes and code

Step 2: Clip Generation
├─ Auto-cut 3 short clips
├─ Convert to vertical format
├─ Add captions
├─ Add music/effects

Step 3: Text Content
├─ Generate blog post from transcript
├─ Create Twitter thread
├─ Write LinkedIn post
├─ Generate email series

Step 4: Visual Content
├─ Create infographics from key points
├─ Design carousel posts
├─ Generate quote cards
└─ Create Pinterest pin

Step 5: Distribution
├─ Schedule all content
├─ Platform-specific optimization
├─ Cross-promotion links
└─ Track performance

Total Automation: 60-70% of repurposing
Manual Touch-ups: 30-40% (quality assurance)
Time Saved: 2-3 hours per video
```

## Integration Points

Works with other Creator Studio plugins:

- **video-editor-ai**: Extract clips automatically
- **subtitle-generator-pro**: Caption all derivatives
- **distribution-automator**: Schedule across platforms
- **seo-metadata-generator**: Optimize each piece
- **analytics-insights**: Track performance

## Best Practices

### Repurposing Strategy
1. **Quality over quantity** - 10 great pieces > 50 mediocre
2. **Platform-specific** - Adapt, don't just repost
3. **Stagger releases** - Spread over 2-4 weeks
4. **Cross-promote** - Link platforms together
5. **Track performance** - Double down on winners

### Content Derivatives Priority
High Value (Do First):
✓ YouTube Shorts (discovery)
✓ Blog post (SEO)
✓ Twitter thread (engagement)
✓ LinkedIn (professional reach)

Medium Value:
✓ TikTok (discovery)
✓ Instagram (engagement)
✓ Reddit (targeted communities)

Low Priority (If Time Allows):
✓ Quora (evergreen SEO)
✓ Pinterest (niche audiences)
✓ Podcast (audio-only audience)

Your goal: Transform every video into a content empire that reaches 10x more people with smart repurposing.
