# YouTube Distribution Checklist

**Complete checklist for uploading and optimizing videos on YouTube**

---

## Pre-Upload Preparation

### Video File

- [ ] **Final video exported** (1080p minimum, 4K if possible)
- [ ] **File format**: MP4 (H.264 codec recommended)
- [ ] **Frame rate**: 30fps or 60fps (consistent throughout)
- [ ] **Audio**: Stereo, 48kHz, AAC codec
- [ ] **File size**: Under 128GB (or 12 hours duration)
- [ ] **Filename**: Descriptive (not "final_v3_FINAL.mp4")

### Thumbnail

- [ ] **Created** with high-quality design
- [ ] **Resolution**: 1280x720 pixels (16:9 aspect ratio)
- [ ] **File size**: Under 2MB
- [ ] **Format**: JPG, PNG, or GIF
- [ ] **Text**: Large, readable on mobile
- [ ] **Face** (if applicable): Clear, expressive, good lighting
- [ ] **A/B test**: Created 2-3 variations
- [ ] **Saved**: Named clearly for future reference

### Title

- [ ] **Written**: Clear and compelling
- [ ] **Length**: Under 60 characters (displays fully on mobile)
- [ ] **Keywords**: Primary keyword at the beginning
- [ ] **Benefit**: Clear value proposition
- [ ] **Tested**: Ran through title analyzer (if available)
- [ ] **No clickbait**: Honest representation of content
- [ ] **Capitalization**: Consistent style

**Title Formula Examples**:
- "[How to] [Accomplish X] in [Timeframe]"
- "[Number] [Topic] Tips That [Benefit]"
- "I Built [Project] in [Timeframe] ([Key Feature])"
- "[Surprising Result] - [What You Did]"

### Description

- [ ] **First 2 lines**: Hook + value prop (shows in preview)
- [ ] **Video summary**: 2-3 sentences about content
- [ ] **Timestamps**: All major sections
- [ ] **Links**: GitHub, website, resources
- [ ] **Social media**: Twitter, LinkedIn, Discord
- [ ] **Related videos**: Link to 2-3 relevant videos
- [ ] **Call to action**: Subscribe, comment, etc.
- [ ] **Hashtags**: 3-5 relevant tags at the end
- [ ] **Keywords**: Naturally included for SEO

**Description Template**:
```
[Hook - what you'll learn/see]

[2-3 sentence summary]

⏱️ TIMESTAMPS
0:00 - Intro
[... all chapters]

🔗 RESOURCES
GitHub: [link]
Documentation: [link]

📚 RELATED VIDEOS
[Video 1]: [link]
[Video 2]: [link]

💬 CONNECT
Twitter: [handle]
Discord: [link]

#[tag1] #[tag2] #[tag3]
```

---

## Upload Process

### Basic Info

- [ ] **Video uploaded** to YouTube Studio
- [ ] **Title added** (optimized version)
- [ ] **Description added** (full template)
- [ ] **Thumbnail uploaded**
- [ ] **Playlist** selected (or created if new series)
- [ ] **Audience** selected (not made for kids - if applicable)
- [ ] **Age restriction** set (if needed)

### Advanced Settings

**Category**:
- [ ] **Category selected**: Science & Technology (for coding), Education, etc.

**Tags**:
- [ ] **Primary keywords** (5-10 tags)
- [ ] **Related terms** (5-10 tags)
- [ ] **Your brand** tags (channel name, series name)
- [ ] **Total tags**: 15-25 (don't spam)

**Language & Captions**:
- [ ] **Video language** selected
- [ ] **Subtitles uploaded** (SRT or VTT file)
- [ ] **Auto-generated captions** reviewed and corrected
- [ ] **Multiple languages** (if applicable)

**Recording Date & Location**:
- [ ] **Recording date** added (optional)
- [ ] **Location** added (optional, for local content)

### Visibility

**Publishing Options**:
- [ ] **Public**: Immediately visible to everyone
- [ ] **Unlisted**: Only people with link can view
- [ ] **Private**: Only you and selected users
- [ ] **Scheduled**: Set date and time for auto-publish

**Premiere** (optional):
- [ ] **Premiere enabled** if desired
- [ ] **Premiere time** scheduled
- [ ] **Trailer added** (30-60 seconds)
- [ ] **Live chat** enabled/disabled

### Monetization

- [ ] **Monetization on** (if eligible)
- [ ] **Ad suitability** reviewed
- [ ] **Mid-roll ads** placed manually (for videos 8+ minutes)
- [ ] **Ad placement** not disrupting key moments

---

## YouTube SEO Optimization

### Chapter Markers

- [ ] **00:00** - Intro/Hook
- [ ] **Chapters created** for each major section
- [ ] **Chapter titles** descriptive and keyword-rich
- [ ] **Minimum length**: Each chapter at least 10 seconds
- [ ] **Listed in description** with timestamps

### End Screen

- [ ] **End screen added** (last 5-20 seconds)
- [ ] **Best for viewers** element (YouTube's recommendation)
- [ ] **Subscribe button** added
- [ ] **Specific video** or playlist promoted
- [ ] **External link** (if eligible - 1000+ subs)
- [ ] **Placement** not blocking important content

### Cards

- [ ] **Cards added** throughout video
- [ ] **Video cards**: Link to related videos
- [ ] **Playlist cards**: Link to series/playlist
- [ ] **Link cards**: External links (if eligible)
- [ ] **Timing**: Placed at natural pauses or mentions
- [ ] **Not overused**: 2-5 cards max

### Community Tab (if 1000+ subscribers)

- [ ] **Post created** announcing new video
- [ ] **Thumbnail attached** (eye-catching)
- [ ] **Short description** (2-3 sentences)
- [ ] **Call to action**: "New video out now!"
- [ ] **Poll** (optional): Ask viewers a related question

---

## Cross-Promotion

### Within Your Channel

- [ ] **Pinned comment** with key links/info
- [ ] **Comment reply prepared** for common questions
- [ ] **Related videos** linked in description
- [ ] **Playlist updated** with new video
- [ ] **Channel trailer** updated (if this is your best video)

### Social Media

**Twitter/X**:
- [ ] **Thread created** (5-7 tweets)
- [ ] **Video link** in first tweet
- [ ] **Key clips** (30 seconds) attached to tweets
- [ ] **Hashtags** relevant to content
- [ ] **Mentions**: Tag relevant accounts
- [ ] **Timing**: Posted at optimal time for your audience

**LinkedIn**:
- [ ] **Article written** (500-1000 words)
- [ ] **Video embedded** (first 2 minutes OR full video)
- [ ] **Professional angle** emphasized
- [ ] **Hashtags** for professional audience
- [ ] **Posted as article** (not just link post)

**Reddit**:
- [ ] **Relevant subreddits** identified (r/webdev, r/programming, etc.)
- [ ] **Context provided** (not just link dump)
- [ ] **Timing**: Best time for each subreddit
- [ ] **Follow-up**: Engage with comments
- [ ] **Not spamming**: Follow 10:1 rule (1 self-promo per 10 contributions)

**Discord/Slack Communities**:
- [ ] **Posted in appropriate channels**
- [ ] **Context given**: Why it's relevant
- [ ] **Not spamming**: Follow community rules

### Email List

- [ ] **Newsletter sent** to subscribers
- [ ] **Subject line** optimized (50-60 characters)
- [ ] **Preview text** compelling
- [ ] **Video embedded** OR thumbnail with link
- [ ] **Key takeaways** listed
- [ ] **Call to action**: Watch, comment, share

### Blog/Website

- [ ] **Blog post created** (optional but valuable for SEO)
- [ ] **Video embedded** at top
- [ ] **Full transcript** included
- [ ] **Key points** highlighted
- [ ] **Code snippets** formatted
- [ ] **Call to action**: Subscribe on YouTube

---

## Post-Upload Actions (Day 1)

### First Hour

- [ ] **Check video** after processing (quality, cards, end screen)
- [ ] **Pin first comment** with links/resources
- [ ] **Share on Twitter** immediately
- [ ] **Post to LinkedIn** within 1 hour
- [ ] **Post to Discord/Slack** in relevant communities
- [ ] **Monitor comments**: Reply within first hour

### First 24 Hours

- [ ] **Respond to all comments** (engagement boosts algorithm)
- [ ] **Share additional clips** on Twitter
- [ ] **Post to Reddit** (if appropriate, with context)
- [ ] **Email newsletter** sent (if scheduled)
- [ ] **Instagram story/post** (if you have presence there)
- [ ] **TikTok/Shorts** (short-form version if created)

### Analytics Check

- [ ] **Views**: Check initial traction
- [ ] **CTR**: Thumbnail/title performance (>5% is good)
- [ ] **Average view duration**: >50% is excellent
- [ ] **Traffic sources**: Where viewers are coming from
- [ ] **Audience retention**: When viewers drop off

---

## Ongoing Optimization (Week 1)

### Engagement

- [ ] **Reply to comments** daily
- [ ] **Heart comments** that add value
- [ ] **Pin best question** (create discussion)
- [ ] **Create community post** (ask related question)
- [ ] **Update pinned comment** with new info if needed

### Performance Tweaks

**If CTR is low (<4%)**:
- [ ] **Change thumbnail** to A/B test variation
- [ ] **Adjust title** (test different hook)

**If retention is low (<40%)**:
- [ ] **Analyze drop-off points** in analytics
- [ ] **Trim intro** on future videos
- [ ] **Improve pacing** on future videos

**If views are low**:
- [ ] **Promote more** on social media
- [ ] **Add to playlist** for discoverability
- [ ] **Cross-promote** in newer videos

### SEO Refinement

- [ ] **Check ranking** for target keywords
- [ ] **Add more tags** if needed (under 25 total)
- [ ] **Update description** with additional keywords
- [ ] **Respond to comments** with keywords naturally included

---

## Long-Term Strategy

### Playlists

- [ ] **Added to relevant playlist**
- [ ] **Playlist title** optimized for search
- [ ] **Playlist description** includes keywords
- [ ] **Playlist order**: Strategic (newest first OR story order)

### Series Building

- [ ] **Next video planned** (if series)
- [ ] **Teased at end** of this video
- [ ] **Consistent schedule** communicated
- [ ] **Playlist created** for series

### Collaborations

- [ ] **Mentioned collaborators** (if any) in description
- [ ] **Tagged in comments** on their channels
- [ ] **Cross-promoted** on both channels

---

## Metrics to Track

### Watch Time
- **Goal**: High watch time = algorithm boost
- **Target**: >50% average view duration
- **Action**: Analyze retention graph, improve pacing

### Click-Through Rate (CTR)
- **Goal**: Compelling thumbnail + title
- **Target**: 5-10% CTR (varies by niche)
- **Action**: A/B test thumbnails and titles

### Engagement Rate
- **Goal**: Likes, comments, shares, saves
- **Target**: >3% engagement rate
- **Action**: Ask questions, encourage discussion

### Traffic Sources
- **Monitor**: Where viewers are coming from
- **Double down**: On best performing sources
- **Improve**: Weak sources (e.g., suggested videos)

### Subscriber Growth
- **Goal**: Net new subscribers from video
- **Target**: 1-5% conversion (views to subscribers)
- **Action**: Strong CTAs, consistent value

---

## Common Mistakes to Avoid

1. **Weak first 30 seconds** - Hook viewers immediately
2. **Generic title** - Be specific and benefit-focused
3. **Ugly thumbnail** - Invest time in design
4. **No timestamps** - Viewers love navigable content
5. **No end screen** - Missing opportunity for next video
6. **No cards** - Missing cross-promotion
7. **No pinned comment** - Wasted prime real estate
8. **Ignoring comments** - Engagement matters
9. **Wrong category** - Affects recommendations
10. **No call to action** - Tell viewers what to do

---

## YouTube Studio Checklist

After upload, double-check in YouTube Studio:

- [ ] **Video processing** complete (HD available)
- [ ] **Thumbnail showing** correctly
- [ ] **Chapters appearing** in video player
- [ ] **End screen displaying** properly
- [ ] **Cards working** (click to test)
- [ ] **Subtitles available** and accurate
- [ ] **Playlist added** correctly
- [ ] **Age restriction** correct (if applicable)
- [ ] **Premiere** scheduled correctly (if applicable)

---

## Day 7 Review

- [ ] **Total views**: Compared to channel average
- [ ] **Watch time**: Compared to typical videos
- [ ] **Engagement**: Comments, likes, shares
- [ ] **Subscriber growth**: Net new subscribers
- [ ] **Traffic sources**: Best performing sources
- [ ] **Audience retention**: Where people drop off
- [ ] **Keywords ranking**: Search console data
- [ ] **Learnings documented**: What worked, what didn't

---

## Tools & Resources

**Title/Thumbnail Testing**:
- TubeBuddy (browser extension)
- VidIQ (browser extension)
- Canva (thumbnail design)

**Analytics**:
- YouTube Studio (native analytics)
- Google Search Console (search traffic)
- Social Blade (channel growth tracking)

**SEO**:
- Google Trends (keyword research)
- Ahrefs YouTube Keyword Tool
- YT Buddy (tag suggestions)

---

**YouTube success = Great content + Strategic optimization. Use this checklist every time.** 🚀

---

**Version**: 1.0.0
**Checklist Type**: YouTube Distribution
