# Demo Video Script Template

**Use this template for**: Product demonstrations, feature showcases, and "show don't tell" videos.

---

## Video Information

**Product/Feature**: [What are you demoing?]
**Target Audience**: [Users, prospects, or developers?]
**Duration Target**: [5-8 minutes for feature demo, 3-5 for quick demo]
**Key Benefit**: [Main value proposition]
**Call to Action**: [Sign up, try it, learn more?]

---

## Script Structure

### HOOK (0:00-0:10) - 10 seconds

**Visual**: [Show the most impressive result immediately]

**Script**:
```
[Show the end result first - the "wow" moment]

"Watch me [accomplish impressive task] in [timeframe]."

[OR alternative:]

"What if you could [benefit] without [current pain point]?"
```

**Example**:
```
[Screen shows: Complex task completed in 3 clicks]

"Watch me deploy a full-stack application in under 60 seconds."
```

---

### PROBLEM (0:10-0:40) - 30 seconds

**Visual**: [Show the old way / competitor way]

**Script**:
```
"Here's the problem:

[Current pain point]
'Right now, to [accomplish task], you have to:
1. [Step 1 - tedious]
2. [Step 2 - complicated]
3. [Step 3 - time-consuming]'

[Quantify the pain]
'This takes [X hours/days] and requires [expertise/tools].'

[Empathy]
'If you're like me, you've wished for a better way.'

[Transition]
'Well, now there is. Let me show you...'"
```

---

### SOLUTION INTRO (0:40-1:10) - 30 seconds

**Visual**: [Your product interface]

**Script**:
```
"Meet [product name].

[One-sentence value proposition]
'[Product] lets you [key benefit] in [time/effort saved].'

[How it works - high level]
'Instead of [old way], you simply [new way].'

[Who it's for]
'Perfect for [target audience] who want to [desired outcome].'

[Transition]
'Let me show you exactly how it works...'"
```

---

### DEMO PART 1: Setup (1:10-2:30) - 80 seconds

**Visual**: [Screen recording - getting started]

**Script**:
```
"First, let's get started:

[Show onboarding - keep it fast]
'Sign up takes 30 seconds...'
[Fast-forward through form]

'Once you're in, here's what you see.'
[Show dashboard/main interface]

[Orient the viewer]
'On the left, you have [navigation]...
In the center, [main area]...
On the right, [sidebar/tools]...'

[First action]
'To [accomplish first task], you simply [action].'

[Show result]
'And just like that, [result].'

[Emphasize ease]
'Notice how simple that was - no [complication from old way].'"
```

**On-Screen Text**:
- "30 seconds to sign up"
- Interface labels
- Action annotations

---

### DEMO PART 2: Key Feature 1 (2:30-4:00) - 90 seconds

**Visual**: [Screen recording - feature in action]

**Script**:
```
"Now let's look at the most powerful feature: [feature name].

[Setup the use case]
'Imagine you need to [common task].'

[Show the feature]
'With [feature], you just [simple action].'

[Walk through step by step]
'First, [step 1]...
Then, [step 2]...
Finally, [step 3]...'

[Show the result]
'And boom - [impressive result] in [timeframe].'

[Compare to old way]
'Compare this to the old way where you'd have to [old tedious process].'

[Additional benefit]
'Plus, [feature] also [additional benefit].'

[Use case callout]
'I use this whenever I need to [specific scenario].'"
```

**On-Screen Text**:
- Feature name highlighted
- Step numbers
- Time saved metric
- Before/after comparison

---

### DEMO PART 3: Key Feature 2 (4:00-5:30) - 90 seconds

**Visual**: [Screen recording - second feature]

**Script**:
```
"Another powerful feature is [feature name].

[Different use case]
'This is perfect when you want to [use case].'

[Demo the feature - faster pacing]
'Simply [action 1], then [action 2], and [result].'

[Power user tip]
'Pro tip: You can also [advanced usage].'

[Show advanced result]
'This lets you [advanced benefit].'

[Emphasize flexibility]
'You can customize this to [customization options].'"
```

---

### DEMO PART 4: Integration/Advanced (5:30-6:30) - 60 seconds

**Visual**: [Screen recording - integrations or advanced features]

**Script**:
```
"[Product] also integrates with [tools]:

[Show integration]
'Connect your [tool 1], [tool 2], and [tool 3]...'

[Demo integrated workflow]
'Now when you [trigger], it automatically [action across tools].'

[Show the power]
'This creates a complete workflow where [end-to-end benefit].'

[Optional: Mention other features]
'There's also [feature X], [feature Y], and [feature Z] that I don't have time to cover, but they're all powerful.'"
```

---

### RESULTS (6:30-7:30) - 60 seconds

**Visual**: [Dashboard showing metrics OR testimonial]

**Script**:
```
"So what kind of results can you expect?

[Metrics/stats]
'Users typically see:
- [Metric 1]
- [Metric 2]
- [Metric 3]'

[Social proof]
'[Customer name] said: "[testimonial quote]"'

[Your personal results]
'Personally, since using [product], I've [your result].'

[Time/cost savings]
'On average, [product] saves [time] and reduces [cost] by [percentage].'

[Transition]
'So how do you get started?'"
```

---

### CALL TO ACTION (7:30-8:00) - 30 seconds

**Visual**: [Signup page OR pricing page]

**Script**:
```
"Getting started is easy:

[CTA]
'Head to [URL] and sign up for free.'

[What they get]
'You'll get [offering details].'

[Limited offer if applicable]
'Right now, [special offer/discount].'

[Next steps]
'Once you're in, [first action to take].'

[Support]
'If you have questions, [support channel].'

[Final push]
'Don't wait - start [achieving benefit] today.'"
```

**On-Screen Text**:
- URL prominently displayed
- Pricing/offer details
- Sign up button

---

### OUTRO (8:00-8:15) - 15 seconds

**Visual**: [Your face OR product logo]

**Script**:
```
"That's [product name].

If this looks useful, hit like and subscribe for more [content type].

Thanks for watching!"
```

---

## Demo Variations

### Quick Demo (3 minutes)
- Hook (10s)
- Problem (20s)
- Solution (30s)
- Key feature only (90s)
- CTA (30s)

### Comprehensive Demo (15 minutes)
- Detailed walkthrough of all features
- Multiple use cases
- Q&A from comments
- Comparison with competitors

### Use Case Demo (8 minutes)
- Specific scenario start to finish
- One complete workflow
- Before/after comparison
- Results and learnings

---

## Recording Tips

**Before Recording**:
- Clean test account (no personal data)
- Prepare sample data
- Close unnecessary tabs/apps
- Test that everything works
- Rehearse the flow

**While Recording**:
- Move mouse slowly and deliberately
- Pause after each action (easier to edit)
- Narrate what you're doing
- Show results clearly
- Keep energy high

**Screen Recording Settings**:
- 1920x1080 resolution
- 60fps if possible
- Include mouse cursor
- Highlight clicks
- Clear audio

---

## On-Screen Annotations

**Feature Highlights**:
```
[Arrow pointing to button]
"Click here to [action]"

[Circle around result]
"Notice the [improvement]"

[Highlight box]
"This shows [information]"
```

**Performance Metrics**:
```
Before: [metric]
After: [metric]
Improvement: [percentage]
```

**Time Savings**:
```
Old way: [X hours]
New way: [Y minutes]
Time saved: [Z]%
```

---

## Description Template

```markdown
Full demo of [product name] - [one-line value proposition]

See how [product] helps you [key benefit] without [pain point].

⏱️ TIMESTAMPS
0:00 - Hook
0:10 - The Problem
0:40 - Solution Intro
1:10 - Getting Started
2:30 - [Feature 1]
4:00 - [Feature 2]
5:30 - [Feature 3]
6:30 - Results & Metrics
7:30 - How to Get Started

🎯 KEY FEATURES
✓ [Feature 1] - [benefit]
✓ [Feature 2] - [benefit]
✓ [Feature 3] - [benefit]
✓ [Feature 4] - [benefit]

📊 RESULTS
- [Metric 1]
- [Metric 2]
- [Metric 3]

🔗 LINKS
Try [Product]: [URL]
Pricing: [URL]
Documentation: [URL]
Support: [URL]

💡 USE CASES
Perfect for:
- [Use case 1]
- [Use case 2]
- [Use case 3]

🎁 SPECIAL OFFER
[Discount/trial information if applicable]

---

#demo #[product-category] #[technology] #productivity #tools
```

---

## Success Metrics

**Good demo indicators**:
- High CTR to product website
- Many "just signed up!" comments
- Questions about specific features
- Comparison questions
- Integration questions
- High like ratio

---

**Show, don't tell. Demos sell when viewers see the value.** 🚀

---

**Version**: 1.0.0
**Template Type**: Demo Video Script
