# Tips Video Script Template

**Use this template for**: Quick tips, best practices, list videos, and "X things you should know" content.

---

## Video Information

**Topic**: [What tips are you sharing?]
**Number of Tips**: [3-10 tips recommended]
**Duration Target**: [1-2 minutes per tip, so 5-15 minutes total]
**Target Audience**: [Beginner/Intermediate/Advanced?]
**Format**: [Talking head, screen recording, or both]

---

## Script Structure

### HOOK (0:00-0:10) - 10 seconds

**Visual**: [Montage of tips OR your face with text overlay]

**Script**:
```
"[Number] [topic] tips that will [benefit].

[Quick preview of best tip]
Including [most interesting tip].

Let's go."
```

**Example**:
```
"5 JavaScript tips that will make your code cleaner.

Including a one-liner that replaces 10 lines of code.

Let's go."
```

**On-Screen Text**:
- Video title
- Tip count
- Your name

---

### INTRO (0:10-0:30) - 20 seconds

**Visual**: [Your face]

**Script**:
```
"Hey everyone, [name] here.

[Topic context]
I've been [working with X] for [timeframe], and I've learned [these tips] that [benefit].

[What you'll learn]
In this video, I'm sharing [number] tips that will help you [specific outcome].

[Structure]
Let's jump right into tip number 1."
```

---

### TIP #1 (0:30-2:00) - 90 seconds

**Visual**: [Screen recording OR split screen]

**Script**:
```
"Tip #1: [Tip title - make it catchy]

[The problem it solves]
'You know how [common problem]?'

[The tip]
'Here's a better way: [solution].'

[Show example - bad way]
'Most people do this:
[Show bad code/approach]'

[Show example - good way]
'Instead, do this:
[Show good code/approach]'

[Explain why]
'This is better because:
- [Benefit 1]
- [Benefit 2]
- [Benefit 3]'

[When to use it]
'Use this whenever you [scenario].'

[Common mistake]
'Watch out: Don't [common mistake].'

[Transition]
'Okay, tip number 2...'"
```

**On-Screen Text**:
- "TIP #1" large header
- Tip title
- Before/after code comparison
- Key benefits list

**Pacing**: Keep energy high, move quickly.

---

### TIP #2 (2:00-3:30) - 90 seconds

**Visual**: [Screen recording]

**Script**:
```
"Tip #2: [Tip title]

[Quick setup]
'This one is simple but powerful.'

[The tip]
'[Solution/technique].'

[Example]
'For example, instead of [old way], you can [new way].'

[Demo]
[Show it working]

[Why it matters]
'This saves [time/effort/resources].'

[Real-world scenario]
'I use this in [real scenario].'

[Pro tip if applicable]
'Pro tip: Combine this with [related tip].'

[Transition]
'Tip number 3...'"
```

**Editing Note**: Tips 2-9 should be faster paced than Tip #1. Keep momentum.

---

### TIP #3 (3:30-5:00) - 90 seconds

**Visual**: [Screen recording]

**Script**:
```
"Tip #3: [Tip title]

[This one is special because...]
'This is my favorite tip because [reason].'

[The tip + demo]
[Show and explain]

[Impact]
'This has saved me [time/headache/resources].'

[Additional context]
'You can also [variation].'

[Transition]
'Moving on to tip 4...'"
```

---

### TIPS #4-7 (5:00-11:00) - ~90 seconds each

**Format for each**:
```
"Tip #[N]: [Title]

[Quick explanation]
[Demo]
[Key benefit]
[When to use]
[Transition]"
```

**Pacing**: Keep getting faster. Build momentum toward the final tip.

---

### TIP #8 (BONUS TIP) (11:00-12:30) - 90 seconds

**Visual**: [Screen recording - show the most impressive tip]

**Script**:
```
"And here's a bonus tip - this is the most powerful one:

Tip #[N]: [Title]

[Build it up]
'This tip alone has [impressive benefit].'

[The tip]
[Explain and demo thoroughly]

[Why it's the best]
'This is game-changing because [reasons].'

[Example impact]
'Since I started using this, [personal result].'

[Encourage trying it]
'Seriously, try this today. You'll thank me later.'

[Transition]
'Alright, let's recap...'"
```

---

### RECAP (12:30-13:30) - 60 seconds

**Visual**: [Your face OR text overlay with list]

**Script**:
```
"Quick recap of all [number] tips:

[List them fast]
1. [Tip 1 title]
2. [Tip 2 title]
3. [Tip 3 title]
4. [Tip 4 title]
5. [Tip 5 title]
6. [Tip 6 title]
7. [Tip 7 title]
8. [Bonus tip title]

[Which to start with]
'If you only implement one, start with [best tip for beginners].'

[Resources]
'All the code examples are in the description and on GitHub.'

[Challenge]
'Try implementing [specific tip] today and let me know how it goes.'"
```

**On-Screen Text**:
- Numbered list of all tips
- GitHub link
- "Which one will you try first?"

---

### CALL TO ACTION (13:30-14:00) - 30 seconds

**Visual**: [Your face]

**Script**:
```
"Which tip was most helpful for you?

Let me know in the comments.

[Content ask]
Want more [topic] tips? Let me know what to cover next.

[Subscribe pitch]
If you found this useful, hit like and subscribe for more [content type].

[Related content]
Check out my video on [related topic] - link in the end screen.

Thanks for watching!"
```

---

## Format Variations

### Quick Tips (3-5 minutes)
- 3 tips
- 60 seconds per tip
- Fast-paced
- Screen recording only

### Comprehensive Tips (15-20 minutes)
- 10+ tips
- 90-120 seconds per tip
- More examples
- Talking head + screen

### Single Tip Deep Dive (5-8 minutes)
- One powerful tip
- Multiple examples
- Common mistakes
- Advanced usage

---

## Tip Structure Template

**For each tip, follow this pattern:**

1. **Title** (5 seconds)
   - Catchy, benefit-focused

2. **Problem** (10 seconds)
   - What pain does this solve?

3. **Solution** (20 seconds)
   - Show the tip/technique

4. **Example** (30 seconds)
   - Before/after demo

5. **Why** (15 seconds)
   - Benefits, reasoning

6. **When** (10 seconds)
   - Use cases, scenarios

**Total per tip**: 90 seconds

---

## Best Practices for List Videos

### Ordering Tips

**Option 1: Ascending Value**
- Save best for last
- Builds anticipation
- "Bonus tip" is the best

**Option 2: Descending Value**
- Start with the best
- Hook viewers immediately
- Keep attention throughout

**Option 3: Logical Progression**
- Beginner → Advanced
- Setup → Implementation → Optimization
- Conceptual → Practical

**Recommended**: Ascending value (save best for last)

---

### Pacing

**First tip**: Slower, more detailed (set the pattern)
**Middle tips**: Faster, maintain energy
**Last tip**: Build it up, make it special
**Bonus tip**: Optional, usually the best one

**Timing guidelines**:
- 3 tips: 2 min per tip
- 5 tips: 1.5 min per tip
- 7 tips: 1 min per tip
- 10 tips: 45 sec per tip

---

### Visual Variety

**Keep it interesting**:
- Mix talking head and screen recording
- Different code examples for each tip
- Vary the backgrounds
- Use animations for transitions
- Show real-world use cases

---

## On-Screen Text Templates

**Tip Header**:
```
TIP #3
[Catchy tip title]
```

**Before/After**:
```
❌ DON'T DO THIS:
[Bad example]

✅ DO THIS INSTEAD:
[Good example]
```

**Benefits List**:
```
WHY THIS WORKS:
✓ [Benefit 1]
✓ [Benefit 2]
✓ [Benefit 3]
```

**Pro Tip**:
```
💡 PRO TIP
[Advanced usage]
```

---

## Title Templates

**Number + Benefit**:
- "5 JavaScript Tips That Will Save You Hours"
- "7 Git Commands Every Developer Should Know"
- "10 CSS Tricks for Better Performance"

**Mistakes Format**:
- "5 Mistakes You're Making with React Hooks"
- "7 SQL Anti-Patterns to Avoid"
- "10 Security Mistakes in Node.js Apps"

**Hidden Knowledge**:
- "5 Python Features You Didn't Know About"
- "7 VS Code Shortcuts That Will Change Your Life"
- "10 Docker Tips Most Tutorials Don't Teach"

**Experience-Based**:
- "5 Things I Wish I Knew Before Learning TypeScript"
- "7 Lessons from 10 Years of Coding"
- "10 Habits That Made Me a Better Developer"

---

## Thumbnail Ideas

**Split Design**:
- Left: Before (bad code)
- Right: After (good code)

**Number Focus**:
- Large "5" or "7" or "10"
- Your face + code in background

**Benefit Focus**:
- "SAVE HOURS" text
- Code screenshot
- Your excited face

**Comparison**:
- "❌ vs ✅" layout
- Before/after examples
- Visual contrast

---

## Description Template

```markdown
[Number] [topic] tips that [benefit]

[Quick summary paragraph]

⏱️ TIMESTAMPS
0:00 - Intro
0:30 - Tip #1: [Title]
2:00 - Tip #2: [Title]
3:30 - Tip #3: [Title]
5:00 - Tip #4: [Title]
6:30 - Tip #5: [Title]
8:00 - Tip #6: [Title]
9:30 - Tip #7: [Title]
11:00 - Bonus Tip: [Title]
12:30 - Recap

📝 ALL TIPS SUMMARY
1. [Tip 1 one-liner]
2. [Tip 2 one-liner]
3. [Tip 3 one-liner]
4. [Tip 4 one-liner]
5. [Tip 5 one-liner]
6. [Tip 6 one-liner]
7. [Tip 7 one-liner]
Bonus: [Bonus tip one-liner]

🔗 RESOURCES
Code Examples: [GitHub link]
Documentation: [link]
Related Video: [link]
Cheat Sheet: [link]

💡 MY FAVORITE
If you only try one, make it Tip #[N] - it's a game-changer.

🎯 YOUR CHALLENGE
Try [specific tip] today and share your results in the comments!

📚 LEARN MORE
[Related topic] Tutorial: [link]
Advanced [topic]: [link]
[Topic] Best Practices: [link]

---

#tips #[technology] #tutorial #coding #programming
```

---

## Common Mistakes to Avoid

1. **Too many tips** - 10+ tips = viewer fatigue
2. **Unequal time** - Each tip should be roughly same length
3. **No examples** - Every tip needs a demo
4. **Too basic** - Mix difficulty levels
5. **No recap** - Always summarize at the end
6. **Weak opener** - Hook with the best or most surprising tip
7. **No CTA** - Ask viewers which tip they'll try

---

## Success Metrics

**Good tips video indicators**:
- High watch time (>50%)
- Comments asking for more tips
- "Trying this now!" comments
- Many saves/bookmarks
- High like ratio
- Requests for related topics

---

## Content Ideas

### By Topic
- "[Language] tips"
- "[Framework] best practices"
- "[Tool] shortcuts"
- "Performance optimization tips"
- "Security tips"
- "Debugging strategies"

### By Experience Level
- "Beginner mistakes to avoid"
- "Intermediate tips"
- "Advanced techniques"
- "Expert-level optimizations"

### By Use Case
- "Tips for [specific project type]"
- "Tips for [job role]"
- "Tips for [industry]"
- "Tips for [team size]"

---

## Follow-Up Content

After a successful tips video:

1. **Deep dive videos** - Expand on individual tips
2. **Advanced version** - "Advanced [topic] tips"
3. **Part 2** - "5 MORE [topic] tips"
4. **Mistakes version** - "[Number] mistakes with [topic]"
5. **Reader questions** - Answer comments with new tips

---

**Keep tips practical, actionable, and immediately useful.** 🚀

---

**Version**: 1.0.0
**Template Type**: Tips Video Script
